import tempfile

from pathlib import Path 
# from forbiditerative import planners as fi
from kstar_planner import planners as kp


# Used in (action) reachability
def is_unsolvable_new_goal(domain, problem, new_goal):
    goal = extract_goal(problem)
    new_problem = problem.replace(goal, f"(:goal {new_goal} )")
    return is_unsolvable(domain, new_problem)

def is_unsolvable(domain, problem):
    with tempfile.NamedTemporaryFile() as domain_temp, \
         tempfile.NamedTemporaryFile() as problem_temp:
        with open(str(domain_temp.name), 'w', encoding='utf8') as file:
            file.write(str(domain))
        with open(str(problem_temp.name), 'w', encoding='utf8') as file:
            file.write(str(problem))

        # plans = fi.plan_diverse_agl(domain_file=Path(str(domain_temp.name)), problem_file=Path(str(problem_temp.name)), number_of_plans_bound=1, timeout=3)
        plans = kp.plan_unordered_topq(domain_file=Path(str(domain_temp.name)), problem_file=Path(str(problem_temp.name)),  quality_bound =1.0, number_of_plans_bound=1, timeout=3)

        if len(plans["planner_error"]) > 0:
            fl = plans["planner_error"].split("\n")[0]
            print(f'Planner error: {fl}')
            # print(plans["planner_error"])
            return False
        if plans is None or len(plans['plans']) == 0:
            # print(plans)
            return plans["unsolvable"]
        return False

def extract_goal(prob):

    a = prob.split("(:goal")[1]
    cp = 1
    for i, c in enumerate(a):
        if c == ")":
            cp -= 1        
        if c == "(":
            cp += 1
        if cp == 0:
            return "(:goal" + a[:i+1]

    assert (False)
