function [x_bar,y_bar] = adaptive_module(stategy,sp)
%
% sp is the saddle point of ft
% stategy represents the final strategy pair
% [x_bar,y_bar] denotes the final advice for the next round

% Observe the feedback payoff function
ft = @(x,y)(x-sp(1)).^2/2-(y-sp(2)).^2/2+(x-sp(1)).*(y-sp(2));
% Get loss functions
losstx = @(x)ft(x,stategy(2));
lossty = @(y)-ft(stategy(1),y);

persistent t T N Lphi Lpsi Dx Dy Gx Gy M eta gamma theta
if isempty(t)
    t = 0; T = 4; M = 4; N = 24;
    Lphi = 2; Dx = 2; Gx = 4;
    Lpsi = 2; Dy = 2; Gy = 4;
    eta   = sqrt(Lphi*Dx*2.^(1:N)/T)'/Gx;
    gamma = sqrt(Lpsi*Dy*2.^(1:N)/T)'/Gy;
    theta = sqrt(2*log(T)/T)/M;
end
persistent x_adv y_adv w_adv m_adv
if isempty(x_adv) || isempty(y_adv) || isempty(w_adv) || isempty(m_adv)
    x_adv = 0; y_adv = 0; w_adv = 1./(1:N)'; m_adv = 1./(1:N)';
end

t = t + 1;
if t > T
    % Doubling trick
    T = 2*T;
    % Update learning rates
    eta   = sqrt(Lphi*Dx*2.^(1:N)/T)'/Gx;
    gamma = sqrt(Lpsi*Dy*2.^(1:N)/T)'/Gy;
    theta = sqrt(2*log(T)/T)/M;
end

% Update weights for the next round
w_adv = w_adv.*exp(-theta*losstx(x_adv));
w_adv = w_adv/norm(w_adv,1);
m_adv = m_adv.*exp(-theta*lossty(y_adv));
m_adv = m_adv/norm(m_adv,1);

% Update experts' advice for the next round
x_adv = (x_adv+(sp(1)+sp(2)-stategy(2))*eta)./(1+eta);
x_adv(x_adv>1) = 1; x_adv(x_adv<-1) = -1;
y_adv = (y_adv+(sp(2)-sp(1)+stategy(1))*gamma)./(1+gamma);
y_adv(y_adv>1) = 1; y_adv(y_adv<-1) = -1;

% Combine the final advice for the next round
x_bar = x_adv'*w_adv; y_bar = y_adv'*m_adv;
