function [x,y,a,b] = adaptive_occo(sp,delay,T)
%
% sp is the payoff function
% delay represents an array of predictors
% T is totla rounds
% (x,y) is the strategy
% (a,b) is the saddle point of ft

d = length(delay);
a = zeros(1,T); b = zeros(1,T);
x = zeros(1,T); y = zeros(1,T);

for t = 1:T
    % Initialize advice and the weight coefficient
    if t == 1
        x_bar = 1; y_bar = 1; xi = ones(d,1)/d;
    end

    % hsp contains information about saddle point of predictors
    hsp = 2*rand(2,d)-1;
    hsp(:,t>delay) = [a(t-delay(t>delay));b(t-delay(t>delay))];

    % Output strategy pair (xt,yt) and observe payoff function
    [x(t),y(t),a(t),b(t),auxiliary] = integration_module([x_bar,y_bar],[hsp;xi'],sp);

    % Update the weight coefficient for the next round
    xi = multipredictor_aggregator(hsp,[a(t),b(t)],auxiliary);

    % Update advice of the second expert for the next round
    [x_bar,y_bar] = adaptive_module([x(t),y(t)],[a(t),b(t)]);
end
