function [x,y, a,b,auxiliary] = integration_module(advice,hsp,sp)
%
% [x_bar,y_bar] denotes the advice of the second expert
x_bar = advice(1); y_bar = advice(2);
% sp is a function which represents the saddle point of ft
% hsp is the saddle point of ht
% (x,y) is the final decision and (a,b) is the saddle point of ft
% auxiliary = [x_hat,x_bar,x_tilde;y_hat,y_bar,y_tilde]

persistent t T Lphi Lpsi Dx Dy EtaSum GammaSum ThetaSum VarThetaSum
% persistent eta gamma theta vartheta
if isempty(t)
    t = 0; T = 4; Lphi = 2; Dx = 2; Lpsi = 2; Dy = 2; eps = 1;
    EtaSum = eps; GammaSum = eps; ThetaSum = eps; VarThetaSum = eps;
end

persistent x_tilde y_tilde w_tilde m_tilde
if isempty(x_tilde) || isempty(y_tilde) || isempty(w_tilde) || isempty(m_tilde)
    x_tilde = 0; y_tilde = 0; w_tilde = [1;1]/2;  m_tilde = [1;1]/2;
end

t = t + 1;
% Doubling trick
if t > T
    T = 2*T;
end

% Update learning rates
eta   = Lphi*Dx*(T+1)/EtaSum;
gamma = Lpsi*Dy*(T+1)/GammaSum;
theta    = log(T)/ThetaSum;
vartheta = log(T)/VarThetaSum;

% Observe the predictor
% hsp contains information about the saddle point of ht
% hsp(1,:) represents the coordinates in X and hsp(2,:) denotes that in Y
% hsp(3,:) is xi, the weight coefficient
ha = hsp(1,:)*hsp(3,:)'; hb = hsp(2,:)*hsp(3,:)';
ht = @(x,y)(x-ha).^2/2-(y-hb).^2/2+(x-ha).*(y-hb) - (ha^2/2-hb^2/2+ha*hb) + ...
    (hsp(1,:).^2/2-hsp(2,:).^2/2+hsp(1,:).*hsp(2,:))*hsp(3,:)';

% Update advice of the first expert and the meta weights
[x_hat,y_hat, w,m] = SRSS_unit(hsp,advice, ...
    [x_tilde,y_tilde],[w_tilde,m_tilde],[eta,gamma,theta,vartheta],T);

% Output strategy pair (xt,yt)
x = [x_hat,x_bar]*w; y = [y_hat,y_bar]*m;

% Observe the feedback payoff function
sp = sp(x+1i*y,t); sp = [real(sp),imag(sp)]; a = sp(1); b = sp(2);
ft = @(x,y)(x-a).^2/2-(y-b).^2/2+(x-a).*(y-b);

% Create payoff matrix and predictor matrix
A = [ft(x_hat,y_hat),ft(x_hat,y_bar);ft(x_bar,y_hat),ft(x_bar,y_bar)];
H = [ht(x_hat,y_hat),ht(x_hat,y_bar);ht(x_bar,y_hat),ht(x_bar,y_bar)];

% Update auxiliary variables for the next round
x_tilde = (x_tilde+((a+b)*sum(m)-y)*eta)/(1+sum(m)*eta);
x_tilde(x_tilde>1) = 1; x_tilde(x_tilde<-1) = -1;
y_tilde = (y_tilde+((b-a)*sum(w)+x)*gamma)/(1+sum(w)*gamma);
y_tilde(y_tilde>1) = 1; y_tilde(y_tilde<-1) = -1;

w_tilde = w_tilde.*exp(-theta*A*m); w_tilde = w_tilde/vecnorm(w_tilde,1);
w_tilde(w_tilde < 1/T) = 1/T; w_tilde(w_tilde > 1-1/T) = 1-1/T;
m_tilde = m_tilde.*exp(vartheta*A'*w); m_tilde = m_tilde/vecnorm(m_tilde,1);
m_tilde(m_tilde < 1/T) = 1/T; m_tilde(m_tilde > 1-1/T) = 1-1/T;

EtaSum = EtaSum + [ft(x_hat,y_hat)-ht(x_hat,y_hat)+ht(x_tilde,y_hat)-ft(x_tilde,y_hat), ...
    ft(x_hat,y_bar)-ht(x_hat,y_bar)+ht(x_tilde,y_bar)-ft(x_tilde,y_bar)]*m;
GammaSum = GammaSum + [ht(x_hat,y_hat)-ft(x_hat,y_hat)+ft(x_hat,y_tilde)-ht(x_hat,y_tilde), ...
    ht(x_bar,y_hat)-ft(x_bar,y_hat)+ft(x_bar,y_tilde)-ht(x_bar,y_tilde)]*w;
ThetaSum = ThetaSum + (w-w_tilde)'*(A-H)*m - KLdiv(w_tilde,w)/theta;
VarThetaSum = VarThetaSum + w'*(H-A)*(m-m_tilde) - KLdiv(m_tilde,m)/vartheta;

% Return auxiliary variables
auxiliary = [x_hat,x_bar,x_tilde;y_hat,y_bar,y_tilde];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [x_hat,y_hat, w,m] = SRSS_unit(hsp,advice,auxiliary,meta_auxiliary,rate,T)
%
% (x_hat,y_hat) is the advice of the first expert
% (w,m) is the weight coefficient from the meta-layer
% hsp contains information about the saddle point of ht
% hsp(1,:) represents the coordinates in X and hsp(2,:) denotes that in Y
% hsp(3,:) is xi, the weight coefficient
a = hsp(1,:)*hsp(3,:)'; b = hsp(2,:)*hsp(3,:)';
ht = @(x,y)(x-a).^2/2-(y-b).^2/2+(x-a).*(y-b) - (a^2/2-b^2/2+a*b) + ...
    (hsp(1,:).^2/2-hsp(2,:).^2/2+hsp(1,:).*hsp(2,:))*hsp(3,:)';
% (x_bar,y_bar) is the advice from adaptive module
x_bar = advice(1); y_bar = advice(2);
% (x_tilde,y_tilde) is the auxiliary variable of the expert-layer
x_tilde = auxiliary(1); y_tilde = auxiliary(2);
% (w_tilde,m_tilde) is the auxiliary weight coefficient of the meta-layer
w_tilde = meta_auxiliary(:,1); m_tilde = meta_auxiliary(:,2);
% eta, gamma, theta and vartheta are leatning rates
eta = rate(1); gamma = rate(2); theta = rate(3); vartheta = rate(4);
% alpha=2/T represents the clipping value

% Initialize
[w,m] = meshgrid(linspace(1/T,1-1/T,20),linspace(1/T,1-1/T,20));
w = w(:)'; m = m(:)'; group = length(w);
run = true; round = 0;
while run
    round = round + 1;
    % Solve the saddle point (x,y) under the assumption that (w,m) is fixed
    x = ((x_tilde+eta*(a+b+(m-1)*y_bar))*(1+gamma)+eta*m.*((a-b+(w-1)*x_bar)*gamma-y_tilde)) ...
        ./((1+eta)*(1+gamma)+w.*m*eta*gamma);
    x(x>1) = 1; x(x<-1) = -1;
    y = ((y_tilde+gamma*(b-a+(1-w)*x_bar))*(1+eta)+gamma*w.*((a+b+(m-1)*y_bar)*eta+x_tilde)) ...
        ./((1+eta)*(1+gamma)+w.*m*eta*gamma);
    y(y>1) = 1; y(y<-1) = -1;

    % Compute the duality gap
    L11 = ht(x,y); L12 = ht(x,y_bar); L21 = ht(x_bar,y); L22 = ht(x_bar,y_bar);
    W_min = w_tilde.*exp(-theta*[L11.*m+L12.*(1-m);L21.*m+L22.*(1-m)]);
    W_min = W_min./vecnorm(W_min,1,1);
    W_min(W_min < 1/T) = 1/T; W_min(W_min > 1-1/T) = 1-1/T;
    M_max = m_tilde.*exp(vartheta*[L11.*w+L21.*(1-w);L12.*w+L22.*(1-w)]);
    M_max = M_max./vecnorm(M_max,1,1);
    M_max(M_max < 1/T) = 1/T; M_max(M_max > 1-1/T) = 1-1/T;
    dualgap = ((L11.*w+L21.*(1-w)).*M_max(1,:)+(L12.*w+L22.*(1-w)).*M_max(2,:) ...
        + KLdiv([w;1-w],w_tilde)/theta - KLdiv(M_max,m_tilde)/vartheta) ...
        - ((L11.*m+L12.*(1-m)).*W_min(1,:)+(L21.*m+L22.*(1-m)).*W_min(2,:) ...
        + KLdiv(W_min,w_tilde)/theta - KLdiv([m;1-m],m_tilde)/vartheta);

    % Successive reduction of search space
    [dgmin,idx] = min(dualgap);
    if dgmin < 1e-15
        run = false;
    else
        w = w(idx)+(rand(1,group)-0.5)/sqrt(2)^round;
        m = m(idx)+(rand(1,group)-0.5)/sqrt(2)^round;
        w(w<1/T) = 1/T; w(w>1-1/T) = 1-1/T;
        m(m<1/T) = 1/T; m(m>1-1/T) = 1-1/T;
    end
end

% Outputs
x_hat = x(idx); w = [w(idx);1-w(idx)];
y_hat = y(idx); m = [m(idx);1-m(idx)];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function dist = KLdiv(p,q)
%
% KL divergence
temp = p.*log(p./q);
temp(isnan(temp)) = 0;
dist = sum(temp);
