clear all; clear functions;

z1 = @(t)log(1+t);
z2 = @(t)log(log(exp(1)+t));
sp{1} = @(s,t) z2(t)*exp(1i*z1(t))/3;
sp{2} = @(s,t) z2(t)*exp(1i*(t*2*pi/3+z2(t)))/3;
sp{3} = @(s,t) exp(1i*(pi+randn+angle(s)))/2;

f = @(x,y,a,b)(x-a).^2/2-(y-b).^2/2+(x-a).*(y-b);
T = 1e3; delay = [5,6,7,8]; avgDG = cell(1,3);
for idx = 1:3
    [x,y,a,b] = adaptive_occo(sp{idx},delay,T);
    dualgap = [f(x,0,a,b) - f(0,y,a,b); ...
        f(x,b./log(1+(1:T)),a,b) - f(a./log(1+(1:T)),y,a,b); ...
        f(x,b-a+x,a,b) - f(a+b-y,y,a,b)];
    avgDG{idx} = (cumsum(dualgap,2)./(1:T))';
end
