function xi = multipredictor_aggregator(hsp,sp,auxiliary)
%
% xi is the weight coefficient for the next round
% hsp contains information about the saddle point of ht
% hsp(1,:) represents the coordinates in X and hsp(2,:) denotes that in Y
% sp is the saddle point of ft
% auxiliary = [x_hat,x_bar,x_tilde;y_hat,y_bar,y_tilde]

persistent t T d ZetaSum xi_old
if isempty(t)
    t = 0; d = size(hsp,2); T = 2*d;
    eps = 1; ZetaSum = eps; xi_old = ones(d,1)/d;
end

t = t + 1;
% Doubling trick
if t > T
    T = 2*T;
end

% Update learning rates
zeta = log(T)/ZetaSum;

% Update loss vector
Loss = zeros(d,1); [x,y] = meshgrid(auxiliary(1,:),auxiliary(2,:));
ft = @(x,y)(x-sp(1)).^2/2-(y-sp(2)).^2/2+(x-sp(1)).*(y-sp(2));
for k = 1:d
    htk = @(x,y)(x-hsp(1,k)).^2/2-(y-hsp(2,k)).^2/2+(x-hsp(1,k)).*(y-hsp(2,k));
    Loss(k) = max(abs(ft(x(:),y(:))-htk(x(:),y(:))));
end

% Update weight coefficient xi for the next round
xi = hedge(xi_old.*exp(-zeta*Loss),d/T);
ZetaSum = ZetaSum + Loss'*(xi_old-xi)-KLdiv(xi,xi_old)/zeta;
xi_old = xi;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function o = hedge(E,alpha)
A = E(:); n = length(A); s = sum(A);
W = 1:n;
c = 0; C = 0;
while ~isempty(W)
    a = median(A(W));
    L = W(A(W)<a); M = W(A(W)==a); H = W(A(W)>a);
    if a*(1-(c+length(L))*alpha/n)/(s-(C+sum(A(L)))) < alpha/n
        c = c+length(L)+length(M);
        C = C+sum(A(L))+sum(A(M));
        if isempty(H)
            a = min(A(A>a));
        end
        W = H;
    else
        W = L;
    end
end
o = A*(1-c*alpha/n)/(s-C); o(A<a) = alpha/n; o = reshape(o,size(E)); 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function dist = KLdiv(p,q)
%
% KL divergence
temp = p.*log(p./q);
temp(isnan(temp)) = 0;
dist = sum(temp);
