# Forward and Backward Lifelong Learning with Time-dependent Tasks (LMRC)

[![made-with-python](https://img.shields.io/badge/Made%20with-Python-1f425f.svg)](/AMRC_Python) [![Made with!](https://img.shields.io/badge/Made%20with-MATLAB-red)](/AMRC_Matlab)  [![Ask Me Anything !](https://img.shields.io/badge/Ask%20me-anything-1abc9c.svg)](#support-and-author)

This repository is the official implementation of Forward and Backward Lifelong Learning with Time-dependent Tasks.

The proposed LMRCs effectively perform forward and backward learning and account for time-dependent tasks.

<img src="intro.png"/>

## Source code

[![made-with-python](https://img.shields.io/badge/Made%20with-Python-1f425f.svg)](LMRC_Python) 
[![Made with!](https://img.shields.io/badge/Made%20with-MATLAB-red)](LMRC_Matlab)

LMRC folder contains the Python and Matlab folders that include the Python and Matlab scripts, respectively, required to run the code.

### Python code

[LMRC_ Python](/LMRC_Python)  folder contains Python scripts required to execute the method:

* run_LMRC.py is the main file. In such file we can modify the values of hyper-parameters such as  <img src="https://render.githubusercontent.com/render/math?math=\lambda_0">, the order, and the feature mapping. In addition, such function tracks uncertainty sets, provides performance guarantees at specific times, and updates classifier parameters.
* efficient_learning.py updates classifier parameters.
* prediction.py assigns label to instances.
* feture_mapping_function.py calculates feature vectors using linear or random Fourier features (RFF) feature mappings.
* forward_backward_learning.py contains functions that obtain mean vector estimates and confidence vectors for single-task, forward, and forward and backward learning.
* requeriments.txt contains versions of Python modules


#### Requirements

The requirements are detailed in the requeriments.txt file. Run the following command to install the requeriments:

```setup
cd LMRC/LMRC_Python
pip install -r requirements.txt
```

### Matlab code

[LMRC_Matlab](/LMRC_Matlab) folder contains Matlab scripts required to execute the method:

* main.m is the main file. In such file we can modify the values of the hyper-parameters and the feature mapping.
* initialize.m initializes model variables.
* single_task.m obtains mean vector estimates, confidence vectors, and classifier parameters with single-task learning.
* forward.m obtains mean vector estimates, confidence vectors, and classifier parameters with forward learning.
* backward.m obtains mean vector estimates, confidence vectors, and classifier parameters with forward and backward learning.
* feature_vector.m calculates feature vectors using linear or random Fourier features (RFF) feature mappings.
* optimization.m updates classifier parameters.
* prediction.m assigns label to instances.

## Installation and evaluation

To train and evaluate the model in the paper, run this command for Python:

```console
cd LMRC/LMRC_Python
python run_LMRC.py

```

and for Matlab:

```console
cd LMRC/LMRC_Matlab
matlab main.m
```
