#!/bin/sh
# Train I-O model
python main.py -m \
    save_checkpoint=False \
    logger.offline=False \
    training.io_mode="I-OR" \
    training.input_type=task \
    data=esnli \
    data.num_train=5000 \
    data.num_dev=1000 \
    data.num_test=1000 \
    model=fine_tuning \
    model.arch=t5-base \
    model.optimizer.lr=5e-5 \
    setup.train_batch_size=64 \
    setup.accumulate_grad_batches=1 \
    setup.eff_train_batch_size=64 \
    setup.eval_batch_size=64 \
    setup.num_workers=3 \
    seed=0,1,2

python main.py -m \
    save_checkpoint=False \
    logger.offline=False \
    training.io_mode="I-OR" \
    training.input_type=task \
    data=esnli \
    data.num_train=5000 \
    data.num_dev=1000 \
    data.num_test=1000 \
    model=fine_tuning \
    model.arch=t5-large \
    model.optimizer.lr=1e-5 \
    setup.train_batch_size=16 \
    setup.accumulate_grad_batches=1 \
    setup.eff_train_batch_size=16 \
    setup.eval_batch_size=16 \
    setup.num_workers=3 \
    seed=0,1,2