#!/bin/sh
# Train I-O model
python main.py -m \
    save_checkpoint=False \
    logger.offline=False \
    training.io_mode="I-O" \
    training.input_type=task \
    data=esnli \
    data.num_train=5000 \
    data.num_dev=1000 \
    data.num_test=1000 \
    model=ftr_fine_tuning \
    model.arch=t5-base \
    model.optimizer.lr=5e-5 \
    model.prompt_length=1 \
    model.prompt_embs=ftr-lm \
    model.freeze_backbone=False \
    model.freeze_prompt_embs=False \
    model.use_cls_prompt=False \
    model.prompt_criterion=ntxent \
    model.prompt_criterion_temp=0.5 \
    model.task_loss_wt=1.0 \
    model.prompt_loss_wt=1.0 \
    model.cf_reg_loss_wt=1.0 \
    model.cf_reg_smooth_wt=0.1 \
    model.cf_reg_dropout=0.0 \
    model.ref_task_loss_wt=0.0 \
    model.combine_src_ref=True \
    model.dropout_aug=True \
    model.use_xbm=False \
    model.xbm_memory_size=null \
    model.share_task_encoder=False \
    model.share_prompt_encoder=True \
    model.share_prompt_embs_init=True \
    model.freeze_src_lm=False \
    model.freeze_ref_lm=False \
    model.replace_task_lm_with_src_lm=False \
    model.e2e=True \
    model.use_task_input=True \
    model.prompt_lm_ckpt=null \
    model.prompt_lm_only=False \
    setup.train_batch_size=64 \
    setup.accumulate_grad_batches=1 \
    setup.eff_train_batch_size=64 \
    setup.eval_batch_size=64 \
    setup.num_workers=3 \
    seed=0,1,2