#!/bin/sh
# Train I-O model
python main.py -m \
    save_checkpoint=False \
    logger.offline=False \
    training.io_mode="I-O" \
    data=strategyqa \
    model=lm \
    model.arch=t5-base \
    model.optimizer.lr=1E-4 \
    model/scheduler=linear_with_warmup \
    model.scheduler.warmup_updates=0.06 \
    setup.train_batch_size=16 \
    setup.accumulate_grad_batches=1 \
    setup.eff_train_batch_size=16 \
    setup.eval_batch_size=16 \
    setup.num_workers=3 \
    seed=0

python main.py -m \
    save_checkpoint=False \
    logger.offline=False \
    training.io_mode="IR-O" \
    data=strategyqa \
    model=lm \
    model.arch=t5-base \
    model.optimizer.lr=3E-4 \
    model/scheduler=linear_with_warmup \
    model.scheduler.warmup_updates=0.06 \
    setup.train_batch_size=16 \
    setup.accumulate_grad_batches=1 \
    setup.eff_train_batch_size=16 \
    setup.eval_batch_size=16 \
    setup.num_workers=3 \
    seed=0

python main.py -m \
    save_checkpoint=False \
    logger.offline=False \
    training.io_mode="I-OR" \
    data=strategyqa \
    model=lm \
    model.arch=t5-base \
    model.optimizer.lr=2E-4 \
    model/scheduler=linear_with_warmup \
    model.scheduler.warmup_updates=0.06 \
    setup.train_batch_size=16 \
    setup.accumulate_grad_batches=1 \
    setup.eff_train_batch_size=16 \
    setup.eval_batch_size=16 \
    setup.num_workers=3 \
    seed=0,1,2

python main.py -m \
    save_checkpoint=False \
    logger.offline=False \
    training.io_mode="I-O","IR-O" \
    data=strategyqa \
    model=lm \
    model.arch=t5-large \
    model.optimizer.lr=5E-5 \
    model/scheduler=linear_with_warmup \
    model.scheduler.warmup_updates=0.06 \
    setup.train_batch_size=16 \
    setup.accumulate_grad_batches=1 \
    setup.eff_train_batch_size=16 \
    setup.eval_batch_size=16 \
    setup.num_workers=3 \
    seed=0,1,2

python main.py -m \
    save_checkpoint=False \
    logger.offline=False \
    training.io_mode="I-OR","I-RO" \
    data=strategyqa \
    model=lm \
    model.arch=t5-large \
    model.optimizer.lr=2E-4 \
    model/scheduler=linear_with_warmup \
    model.scheduler.warmup_updates=0.06 \
    setup.train_batch_size=16 \
    setup.accumulate_grad_batches=1 \
    setup.eff_train_batch_size=16 \
    setup.eval_batch_size=16 \
    setup.num_workers=3 \
    seed=0,1,2