# conda activate vode

GPU=0
HIST0="False"
IMSIZE=32

PLOT_FREQ=2
VAL_FREQ=2
# If joint
EPOCHS=100
BS=32

##############################
# JOINT WAVELET!!!!!
# 1x1x1, 3x1x1, 2x2, 4x4, 8x8, 16x16, 32x32
MODE="wavelet_uni"
JOINT='True'
MAXSCALES=3
NUMBLOCKS=20
BS=160
# NUMBLOCKS=8
# MAXSCALES=2
# BS=400
# NUMBLOCKS=20
# MAXSCALES=2
# BS=180
# NUMBLOCKS=20
# MAXSCALES=3
# NUMBLOCKS=6
# BS=600
# MAXSCALES=3
# NUMBLOCKS=20
# BS=600
DIMS="64,64,64"
STRIDES="1,1,1,1"
HIST0="False"
EPOCHS=200
METRICBS="64"
###############################


# Data
DATA='cifar10'
DATAPATH='/path/to/CIFAR10'

# Save
SAVE="/path/to/save/${DATA}/${MAXSCALES}SC${MODE}"

# Model

SCALEF=0.5
SCALE=0
LOADCKPT=''

BN='False'

CONCATINPUT='True'
NOISE='True'

LR=0.001
LRPS="0.001"

WARM=500
GAMMA=1.0

OPT='adam'

# Reconstruction
MLELAMBDA=1.0
RECON='None'
RECONLAMBDA=0.2
RECONGRADNORM=50.0

# Adv
ADVLOSS='HingeGAN'
ADVLR=0.0001
ADVCH=64
DITERS=1
ADVCONCAT='True'

# Reg
KE=0.01
JF=0.01
STEER=0.0

MAXGRADNORM=100.0

# Solvers
SOLVER='bosh3'
STEPSIZE=0.25
TESTSOLVER='bosh3'

METRICFREQ=10

# 4. Launch your job
CUDA_VISIBLE_DEVICES=$GPU python \
  ../train_cnf_multiscale.py \
  --data $DATA --data_path $DATAPATH --im_size $IMSIZE \
  --save_path $SAVE \
  --mode $MODE --hist0 $HIST0 \
  --max_scales $MAXSCALES --scale_factor $SCALEF --scale $SCALE --ckpt_to_load $LOADCKPT \
  --dims $DIMS --strides $STRIDES --num_blocks $NUMBLOCKS \
  --concat_input $CONCATINPUT --add_noise $NOISE \
  --mle_lambda $MLELAMBDA \
  --recon_loss $RECON --recon_lambda $RECONLAMBDA --recon_max_grad_norm $RECONGRADNORM \
  --adv_loss $ADVLOSS --adv_lr $ADVLR --adv_ch $ADVCH --adv_iters_per_D $DITERS --adv_concat $ADVCONCAT \
  --joint $JOINT --num_epochs $EPOCHS --batch_size $BS \
  --epochs_per_scale $EPOCHSPERSCALE --batch_size_per_scale $BSPERSCALE \
  --optimizer $OPT --lr $LR --lr_per_scale $LRPS --lr_warmup_iters $WARM --lr_gamma $GAMMA --plateau_patience 10000 \
  --kinetic-energy $KE --jacobian-norm2 $JF --steer_b $STEER --max_grad_norm $MAXGRADNORM \
  --solver $SOLVER --step_size $STEPSIZE --atol 1e-3 --rtol 1e-3 \
  --test_solver $TESTSOLVER --test_atol 1e-5 --test_rtol 1e-5 \
  --metric_bs $METRICBS --metric_freq $METRICFREQ \
  --plot_freq $PLOT_FREQ --val_freq $VAL_FREQ \
  --copy_scripts True \
  --seed 29 \
  # --disable_date \
