# Multi-Resolution Continuous Normalizing Flows (MRCNF)

This repository contains code to reproduce results in [https://arxiv.org/abs/2106.08462]("Multi-Resolution Continuous Normalizing Flows (MRCNF)").

## Examples
This code is an application of multi-resolution neural ODEs to density estimation and generative modeling using the FFJORD framework.
To reproduce FFJORD results *without* regularization on MNIST/CIFAR10, run
```
python train_cnf.py --data mnist --save experiments/vanilla
```
To run an experiment using regularization with a fast fixed-grid ODE solver, run
```
python train_cnf.py --data mnist --save experiments/rnode --kinetic-energy 0.01 --jacobian-norm2 0.01 --solver rk4 --step_size 0.25
```

## Data download
```
ds = torchvision.datasets.MNIST('/home/voletiv/GitHubRepos/ffjord-multiscale-rnode/data/', train=True, transform=None, target_transform=None, download=True)
ds = torchvision.datasets.FashionMNIST('/home/voletiv/GitHubRepos/ffjord-multiscale-rnode/data/', train=True, transform=None, target_transform=None, download=True)
```

## Install steps

(https://dev.to/waylonwalker/installing-miniconda-on-linux-from-the-command-line-4ad7)
Install miniconda:
```
mkdir -p ~/miniconda3
wget https://repo.anaconda.com/miniconda/Miniconda3-latest-Linux-x86_64.sh -O ~/miniconda3/miniconda.sh
bash ~/miniconda3/miniconda.sh -b -u -p ~/miniconda3
rm -rf ~/miniconda3/miniconda.sh
~/miniconda3/bin/conda init bash
~/miniconda3/bin/conda init zsh
```

Deactivate automatic launch of `base` env:
```
conda config --set auto_activate_base false
```

Create new environment:
```
conda update conda
conda create -n vode python=3.6
conda activate vode
```

Install packages:
```
pip install h5py imageio matplotlib numpy opencv-python pandas pyyaml sklearn scikit-image scipy tqdm
pip install torch torchvision
```

## Many thanks
FFJORD-RNODE was gratefully forked from [https://github.com/cfinlay/ffjord-rnode](https://github.com/cfinlay/ffjord-rnode), which is based on FFJORD [https://github.com/rtqichen/ffjord](https://github.com/rtqichen/ffjord), which is based on the Neural ODE code in [https://github.com/rtqichen/torchdiffeq](https://github.com/rtqichen/torchdiffeq).
