#!/bin/bash

conda create -n fragfm python=3.9 -y
source "$(conda info --base)/etc/profile.d/conda.sh"   # Enable conda in the script
conda activate fragfm
# ML
conda install scipy=1.11.3 numpy=1.26.0 pandas=2.1.1 scikit-learn=1.3.0 -y
conda install pytorch==1.11.0 cudatoolkit=11.3 -c pytorch -y
pip install torch-scatter==2.0.9 torch-sparse==0.6.15 torch-cluster==1.6.0 torch-geometric==2.1.0.post1 -f https://data.pyg.org/whl/torch-1.11.3+cu113.html
# pip install accelerate==1.2.0
# pip install transformers
# cheminformatics
pip install rdkit==2023.9.2 
pip install git+https://github.com/bp-kelley/descriptastorus 
# utils
pip install wandb==0.18.6
pip install lmdb==1.5.1
pip install pyyaml==6.0.1
pip install easydict==1.13
pip install parmap==1.7.0
# plots
pip install matplotlib==3.8.1
pip install seaborn==0.13.0
pip install pre-commit

pip install -e .
