#!/usr/bin/env sh
DATE="000000" # e.g. 20231001

datasets="debug" # debug set is a 1000 molecule subset of the moses dataset
#datasets="debug moses guacamol zinc250k" 

for dataset in $datasets; do
  for i in $(seq 0 31); do
    python process/process_to_lmdb.py "$dataset" brics "$DATE" "$i" 32 &
  done
  wait
  echo "All jobs for $dataset completed."

  python process/process_merge_lmdbs.py "data/processed/${dataset}_brics_${DATE}/"
  python process/process_fragment_from_lmdb.py "$dataset" brics "$DATE"
done