class Const(object):
    class ConstError(TypeError):
        pass

    class ConstCaseError(ConstError):
        pass

    def __setattr__(self, name, value):
        if name in self.__dict__:
            raise self.ConstError("Can't change const.%s" % name)
        self.__dict__[name] = value

CON = Const()

CON.game_description = """你现在正在玩一种叫做“狼人杀”的游戏。
在这款游戏中，玩家通常被分为两个阵营：狼人和村民。
狼人杀游戏中不同角色的玩家有不同的目标：
- 村民的目的是识别出狼人，并通过投票使他们出局。
- 对于狼人来说，他们的主要目标是隐藏他们的真实身份，在讨论中误导他人，以免被投票出局并尽可能的猎杀村民。
以下是一些基本规则：
- 身份：玩家的身份是秘密分配的。狼人彼此知道对方的身份，而村民只知道自己的身份。
- 昼夜更替：游戏有交替的白天和黑夜阶段。夜里，狼人秘密选择一名村民猎杀。白天，所有玩家讨论并投票决定他们认为是狼人的玩家，票数最多的玩家被淘汰。
- 特殊角色：游戏中有存在一些有特殊能力的角色，比如能得知玩家身份的“预言家”、具有治疗和毒杀能力的“女巫”等。
- 获胜条件：当游戏中有一个群体实现它们的获胜条件时游戏结束。如果所有狼人被淘汰，村民就获胜。如果狼人杀死了所有普通村民或所有特殊角色，狼人就获胜。
在这个游戏中，我们有从1到9号共9名玩家 —— 6名村民和3名狼人。村民中有特殊角色，包括：
- 1位预言家：
    - 目标：预言家的目的是帮助村民识别狼人。
    - 能力：在夜晚阶段，预言家可以秘密选择一名玩家，每晚了解他的真实身份（是否为狼人）。
- 1位女巫：
    - 目标：女巫的目的是策略性地使用她的特殊能力来帮助村民。
    - 能力：女巫有一瓶解药和一瓶毒药。一旦使用，后续回合中不能再用。女巫不能在同一晚既使用解药又使用毒药。解药可以用来救一名在夜间被狼人猎杀的玩家。毒药可以淘汰一名很可能是狼人的玩家。
- 1位守卫：
    - 目标：守卫的目的是策略性地使用他的特殊能力来帮助村民。
    - 能力：守卫每晚可以保护一名玩家，防止他们受到狼人的攻击。守卫可以选择保护自己，或者选择不保护任何人，但他不能在连续两个夜晚保护同一个玩家。
其他的都是普通村民。
"""

CON.game_description_9p = """你现在正在玩一种叫做“狼人杀”的游戏。
在这款游戏中，玩家通常被分为两个阵营：狼人和村民。
狼人杀游戏中不同角色的玩家有不同的目标：
- 村民的目的是识别出狼人，并通过投票使他们出局。
- 对于狼人来说，他们的主要目标是隐藏他们的真实身份，在讨论中误导他人，以免被投票出局并尽可能的猎杀村民。
以下是一些基本规则：
- 身份：玩家的身份是秘密分配的。狼人彼此知道对方的身份，而村民只知道自己的身份。
- 昼夜更替：游戏有交替的白天和黑夜阶段。夜里，狼人秘密选择一名村民猎杀。白天，所有玩家讨论并投票决定他们认为是狼人的玩家，票数最多的玩家被淘汰。
- 特殊角色：游戏中有存在一些有特殊能力的角色，比如能得知玩家身份的“预言家”、具有治疗和毒杀能力的“女巫”等。
- 获胜条件：当游戏中有一个群体实现它们的获胜条件时游戏结束。如果所有狼人被淘汰，村民就获胜。如果狼人杀死了所有普通村民或所有特殊角色，狼人就获胜。
在这个游戏中，我们有从1到9号共9名玩家 —— 6名村民和3名狼人。村民中有特殊角色，包括：
- 1位预言家：
    - 目标：预言家的目的是帮助村民识别狼人。
    - 能力：在夜晚阶段，预言家可以秘密选择一名玩家，每晚了解他的真实身份（是否为狼人）。
- 1位女巫：
    - 目标：女巫的目的是策略性地使用她的特殊能力来帮助村民。
    - 能力：女巫有一瓶解药和一瓶毒药。一旦使用，后续回合中不能再用。女巫不能在同一晚既使用解药又使用毒药。解药可以用来救一名在夜间被狼人猎杀的玩家。毒药可以淘汰一名很可能是狼人的玩家。
{god_description}其他的都是普通村民。
"""

CON.game_description_7p = """你现在正在玩一种叫做“狼人杀”的游戏。
在这款游戏中，玩家通常被分为两个阵营：狼人和村民。
狼人杀游戏中不同角色的玩家有不同的目标：
- 村民的目的是识别出狼人，并通过投票使他们出局。
- 对于狼人来说，他们的主要目标是隐藏他们的真实身份，在讨论中误导他人，以免被投票出局并尽可能的猎杀村民。
以下是一些基本规则：
- 身份：玩家的身份是秘密分配的。狼人彼此知道对方的身份，而村民只知道自己的身份。
- 昼夜更替：游戏有交替的白天和黑夜阶段。夜里，狼人秘密选择一名村民猎杀。白天，所有玩家讨论并投票决定他们认为是狼人的玩家，票数最多的玩家被淘汰。
- 特殊角色：游戏中有存在一些有特殊能力的角色，比如能得知玩家身份的“预言家”等。
- 获胜条件：当游戏中有一个群体实现它们的获胜条件时游戏结束。如果所有狼人被淘汰，村民就获胜。如果狼人杀死了所有普通村民或所有特殊角色，狼人就获胜。

在这个游戏中，我们有从1到7号共7名玩家 —— 5名村民和2名狼人。村民中有特殊角色，包括：
- 1位预言家：
    - 目标：预言家的目的是帮助村民识别狼人。
    - 能力：在夜晚阶段，预言家可以秘密选择一名玩家，每晚了解他的真实身份（是否为狼人）。
{god_description}其他的都是普通村民。"""

CON.guard_description="""- 1位守卫：
    - 目标：守卫的目的是策略性地使用他的特殊能力来帮助村民。
    - 能力：守卫每晚可以保护一名玩家，防止他们受到狼人的攻击。守卫可以选择保护自己，或者选择不保护任何人，但他不能在连续两个夜晚保护同一个玩家。
"""

CON.hunter_description = """- 1位猎人：
    - 目标：猎人的目的是策略性地使用他的特殊能力帮助村民消灭狼人。
    - 能力：当猎人被狼人杀害或者在白天被放逐出局后，他可以翻开自己的身份牌并向场上任意一位活着的玩家射出一发复仇的子弹，带着这位玩家一起死亡。猎人可以选择不翻牌，但是只要翻了牌就必须带人（注意，当猎人被女巫毒杀后，不能翻牌带人）。
"""

CON.witch_description = """- 1位女巫：
    - 目标：女巫的目的是策略性地使用她的特殊能力来帮助村民。
    - 能力：女巫有一瓶解药和一瓶毒药。一旦使用，后续回合中不能再用。女巫不能在同一晚既使用解药又使用毒药。解药可以用来救一名在夜间被狼人猎杀的玩家。毒药可以淘汰一名很可能是狼人的玩家。
"""


CON.identity_chinese = {
    "Seer": "预言家",
    "Witch": "女巫",
    "Guard": "守卫",
    "Villager": "村民",
    "Werewolf": "狼人",
    "Hunter": "猎人"
}


CON.identity_abilities = {
    "Seer": "你每晚可以查看一名玩家是否为狼人，你的目标是利用这些信息帮助其他人找出并淘汰所有狼人。",
    "Witch": "你拥有一瓶救人的药水和一瓶毒杀的药水，你的目标是策略性利用这些能力来保护村民或淘汰狼人。",
    "Guard": "你每晚可以保护一名玩家不被狼人杀害，你的目标是明智地使用这个能力来减少村民的伤亡。",
    "Villager": "你没有特殊能力，但你的目标是观察、讨论并投票揭示狼人的身份，并努力生存下来。",
    "Werewolf": "你需要和其他狼人合作，每晚选择一个村民猎杀，你的目标是隐藏你的身份，并误导其他玩家，直至狼人获得游戏的胜利。",
    "Hunter": "你可以在被狼人猎杀或者被村民放逐的时候，选择开枪击杀一名在场玩家，你的目标是观察、讨论并投票揭示狼人的身份。"
}

CON.werewolf_skill_prompt_v3 = """请综合角色设定、客观信息和主观信息（客观信息一定为真，主观信息不一定真实），思考在场好人的真实底牌身份，选择你要杀害的玩家，请用关键字为'杀害'、‘原因‘的json格式输出，直接输出玩家编号，不选择杀害任何人输出否。"""
CON.seer_skill_prompt_v3 = """请结合以上角色设定、客观信息和主观信息（客观信息一定为真，主观信息包含欺骗性内容），根据投票情况分析潜在的站边关系，并进一步分析玩家隐藏的真实身份信息，选择你要查验的玩家，请用关键字为'查验'、‘原因’的json格式输出，直接输出玩家编号。"""
CON.guard_skill_prompt_v3 = """请结合以上角色设定、客观信息和主观信息（客观信息一定为真，主观信息包含欺骗性内容），分析潜在的站边关系和玩家的身份信息并选择选择你要守卫的玩家，请用关键字为'守卫'、‘原因‘的json格式输出，直接输出玩家编号，不选择守卫任何人输出否。"""
CON.witch_skill_prompt_v3 = """请结合以上角色设定、客观信息和主观信息（客观信息一定为真，主观信息包含欺骗性内容），思考各玩家真实的身份标签，选择解救和毒杀的对象：
- {wolf_killed_info}你有一瓶解药要用吗？如果使用，输出“是”，不使用则输出“否”。
- 你有一瓶毒药要用吗？如果使用，直接输出玩家编号，不使用则输出“否”。请用关键字为“解药”、“毒药”和“原因”的json格式输出。"""
CON.hunter_skill_prompt_v3 = """请综合角色设定、客观信息和主观信息（客观信息一定为真，主观信息不一定真实），思考并推测在场玩家的真实身份，选择你要开枪带走的玩家，请用关键字为'击杀'、‘原因‘的json格式输出，不选择击杀任何人输出否。"""

CON.player_identity_info = """
你是{player_idx}号玩家。
你的身份是：{identity}。
{identity_ability}"""


CON.skill_prompt = """
** 游戏说明
{game_description}
{player_identity_info}

** 游戏日志
{logs}

请根据游戏日志，从下列动作列表中选择一个你要执行的动作。
{valid_actions}

请严格按照动作列表中的内容输出，不要改动或者删减内容，也不要选择列表以外的动作。

** 输出
"""

CON.speech_prompt = """
** 游戏说明
{game_description}
{player_identity_info}

** 游戏日志
{logs}

请根据游戏日志，直接输出你本轮的发言。

** 输出 
"""

CON.vote_prompt = """
** 游戏说明
{game_description}
{player_identity_info}

** 游戏日志
* public logs
{logs}

请根据游戏日志，从下列动作中选择一个你要执行的动作。
{valid_actions}

请严格按照动作列表中的内容输出，不要改动或者删减内容，也不要选择列表以外的动作。

** 输出 
"""


CON.skill_prompt_v3 = """在本场游戏中，你目前已知以下信息：
1. 角色设定：
{player_identity_info}
2. 客观信息：
{objective_info}
3. 主观信息：
{subjective_info}
{your_role}{instruction_prompt}
"""

CON.speech_prompt_v3 = """在本场游戏中，你目前已知以下信息：
1. 角色设定：
{player_identity_info}
2. 客观信息：
{objective_info}
3. 主观信息：
{subjective_info}
{your_role}请综合角色设定、客观信息以及主观信息分析场上目前的局势（注意客观信息一定为真实的，主观信息可能包含欺骗性的发言），总结接下来的发言意图（包括发言中希望向大家呈现的身份、发言中为每位玩家贴上的身份标签以及最终的归票）并组织你本轮的发言。请用关键字为“想要展示的身份”、“身份标签”、“归票”和“发言”的json格式输出。
"""

CON.vote_prompt_v3 = """在本场游戏中，你目前已知以下信息：
1. 角色设定：
{player_identity_info}
2. 客观信息：
{objective_info}
3. 主观信息：
{subjective_info}
{your_role}请综合角色设定、客观信息以及主观信息分析场上目前的局势并形成你本轮的笔记（注意客观信息一定为真实的，主观信息可能包含欺骗性的发言），要求对夜晚信息和玩家发言进行总结和分析，并输出投票原因和要投票出局的玩家，直接输出玩家编号数字；如果弃票，请输出“弃票”。请用关键字为“笔记”、“投票原因”和“投票玩家”的json格式输出。
"""
