# Installation and Quickstart

Here we give the steps to install our benchmarks and baselines, as well as running experiments.

## Create Python Environment

We recommend to not install our packages into your system python environment, but instead to use
[conda](https://docs.conda.io/en/latest/), [virtualenv](https://virtualenv.pypa.io/en/latest/), or
[pyenv](https://github.com/pyenv/pyenv), to create a new python environment. Below we give instructions for installing
conda locally, and for creating an environment. We require a python version greater than `3.6`.
However, `python-3.8` might not work with the XGB and SVM benchmarks.

If conda is not installed, you can install miniconda and activate it as below
```
wget https://repo.continuum.io/miniconda/Miniconda3-latest-Linux-x86_64.sh -O install_miniconda.sh
bash install_miniconda.sh -p miniconda
source .miniconda/bin/activate
```

To create an environment to try our code, use e.g.,
```
conda create -n htaa python=3.7
conda activate htaa
```

## Install our Packages

You can install our python packages `hp_transfer_benchmarks`, `hp_transfer_optimizers`, and `hp_transfer_aa_experiments`,
with

```
pip install ./ht_benchmarks
pip install ./ht_optimizer
pip install ./htaa_experiments
```

## Run a First Experiment

We recommend performing an experiment on one of the FCN or NAS benchmarks first, as the setup and runs are cheap compared to the
other benchmarks.

To setup FCN, you need to download the tabular data
```
python -m hp_transfer_benchmarks.fcnet.download --output_dir data/fcnet
```

After the setup you can then run a first experiment with
```
python -m hp_transfer_aa_experiments.run \
  approach=tpe \
  benchmark=fcnet_aa \
  benchmark.data_path=data/fcnet \
  benchmark.trajectory_id=protein \
  benchmark.adjustment_id=a
```
You can find the results in `./results`. We describe the structure of the results in `experiments/README.md`.
