import torch
from diffusers import StableDiffusionPipeline
from PIL import Image

# 设置设备
device = "cuda:0" if torch.cuda.is_available() else "cpu"

# 直接加载训练好的完整pipeline（无需单独处理UNet）
model_path = "trained_pipeline_folder"  # 训练时保存的pipeline路径
pipe = StableDiffusionPipeline.from_pretrained(
    model_path, 
    torch_dtype=torch.float32, 
    safety_checker=None
)
pipe = pipe.to(device)

# 生成参数配置
prompt = "The starry night by van gogh"
negative_prompt = "ugly, blurry, low quality, disfigured"
num_inference_steps = 50
guidance_scale = 7.5

# 生成图像
with torch.autocast(device_type=device.type):
    image = pipe(
        prompt=prompt,
        negative_prompt=negative_prompt,
        num_inference_steps=num_inference_steps,
        guidance_scale=guidance_scale
    ).images[0]

# 保存图像
save_path = "generated_starry_night.png"
image.save(save_path)
print(f"Image generated and saved to: {save_path}")
