using GerryChain
using TickTock
using Plots, Shapefile
using Printf
using JLD
using SparseArrays
using Random 

### METADATA ###
OUTPUT_FILENAME= "random_spanning_trees_NC" 
SHAPEFILE_PATH = "Shapefiles/NC/NC_VTD.shp"
POPULATION_COL = "TOTPOP"
NUM_TREES      = 100 

# Initialize graph 
graph = BaseGraph(SHAPEFILE_PATH, POPULATION_COL)
all_nodes = collect(1:graph.num_nodes) 
all_edges = induced_subgraph_edges(graph, all_nodes) 

# Initialize the data object
trees = Array{Union{Nothing, BitSet}}(nothing, NUM_TREES)

# Generate the trees
println("Starting generating ", NUM_TREES, " trees...")
taskrng = Random.default_rng() 
tick()
for i = 1:NUM_TREES

    Random.seed!(taskrng, rand(UInt32))
    trees[i] = random_kruskal_mst(graph, all_edges, all_nodes, taskrng)

end
tock()
println("Finished generating ", NUM_TREES, " trees.")

println("Starting saving ", NUM_TREES, " trees...")
tick()
save(string(OUTPUT_FILENAME, ".jld"), "trees", trees)
tock()
println("Finished saving ", NUM_TREES, " trees.")


