export CUDA_VISIBLE_DEVICES=0,1,2,3
export NGPUS=4
export OMP_NUM_THREADS=12

# To eval GSCA-50, 101 and 152, please run
python -m torch.distributed.launch --nproc_per_node=$NGPUS main.py -a gsca_resnet50 --b 128 -e --evaluate_model /path/to/your/gsca50.pth /path/to/your/ImageNet
python -m torch.distributed.launch --nproc_per_node=$NGPUS main.py -a gsca_resnet101 --b 128 -e --evaluate_model /path/to/your/gsca101.pth /path/to/your/ImageNet
python -m torch.distributed.launch --nproc_per_node=$NGPUS main.py -a gsca_resnet152 --b 128 -e --evaluate_model /path/to/your/gsca152.pth /path/to/your/ImageNet

# To eval GSCA-ResNeXt50, GSCA-MobileNetV2 and GSCA-ShuffleNetV2, please run
python -m torch.distributed.launch --nproc_per_node=$NGPUS main.py -a gsca_resnext50 --b 128 -e --evaluate_model /path/to/your/gsca_resnext50.pth /path/to/your/ImageNet
python -m torch.distributed.launch --nproc_per_node=$NGPUS main.py -a gsca_mobilenetv2 --b 128 -e --evaluate_model /path/to/your/gsca_mobilenetv2.pth /path/to/your/ImageNet
python -m torch.distributed.launch --nproc_per_node=$NGPUS main.py -a gsca_shufflenet_v2_x1_0 --b 128 -e --evaluate_model /path/to/your/gsca_shufflenet_v2_x1_0.pth /path/to/your/ImageNet