export CUDA_VISIBLE_DEVICES=0,1,2,3
export NGPUS=4
export OMP_NUM_THREADS=12

# Before testing, please edit the `pretrained` path of pretrained ImageNet GSCA model in \
# ./mmdetection/mmdet/models/backbones/gsca_resnet.py

# And modify the `data_root` path of COCO in \
# ./mmdetection/configs/_base_/datasets/coco_detection.py
# ./mmdetection/configs/_base_/datasets/coco_instance.py

# To eval the results of detection with GSCA-50 and GSCA-101, please run
./mmdetection/tools/dist_train.sh 'mmdetection/configs/retinanet/retinanet_r50_gsca_fpn_1x_coco.py' 'retinanet_r50_gsca.pth'  $NGPUS  --eval bbox
./mmdetection/tools/dist_test.sh 'mmdetection/configs/faster_rcnn/faster_rcnn_r50_gsca_fpn_1x_coco.py' 'faster_r50_gsca.pth' $NGPUS --eval bbox
./mmdetection/tools/dist_test.sh 'mmdetection/configs/faster_rcnn/faster_rcnn_r101_gsca_fpn_1x_coco.py' 'faster_r101_gsca.pth' $NGPUS --eval bbox


# To eval the results of instance segmentation with GSCA-50, please run
./mmdetection/tools/dist_test.sh 'mmdetection/configs/mask_rcnn/mask_rcnn_r50_gsca_fpn_1x_coco.py' 'mask_r50_gsca.pth' $NGPUS --eval bbox segm