export CUDA_VISIBLE_DEVICES=0,1,2,3
export NGPUS=4
export OMP_NUM_THREADS=12

# To train a GSCA-50 using APEX mixed precision, please run
python -m torch.distributed.launch --nproc_per_node=$NGPUS --master_port 14213 main.py -a gsca_resnet50 -b 64 --lr 0.1--loss-scale 128.0 --opt-level O1 /path/to/your/ImageNet

# -a: the target architecture, including gsca_resnet{50/101/152}, gsca_resnext50, gsca_mobilenetv2, and gsca_shufflenet_v2_x1_0. 
# -b: batchsize. 
# --lr: the initial learning rate. 