export CUDA_VISIBLE_DEVICES=0,1,2,3
export NGPUS=4
export OMP_NUM_THREADS=12

# Before training, please edit the `pretrained` path of pretrained ImageNet  GSCA model in \
# ./mmdetection/mmdet/models/backbones/gsca_resnet.py

# And modify the `data_root` path of COCO in \
# ./mmdetection/configs/_base_/datasets/coco_detection.py
# ./mmdetection/configs/_base_/datasets/coco_instance.py


# To train a Faster RCNN using GSCA-50, please run
./mmdetection/tools/dist_train.sh mmdetection/configs/faster_rcnn/faster_rcnn_r50_gsca_fpn_1x_coco.py $NGPUS

# To train a Faster RCNN using GSCA-101, please run
./mmdetection/tools/dist_train.sh mmdetection/configs/faster_rcnn/faster_rcnn_r101_gsca_fpn_1x_coco.py  $NGPUS

# To train a Mask RCNN using GSCA-50, please run
./mmdetection/tools/dist_train.sh mmdetection/configs/faster_rcnn/mask_rcnn_r50_gsca_fpn_1x_coco.py $NGPUS

# To train a RetinaNet using GSCA-50, please run
./mmdetection/tools/dist_train.sh mmdetection/configs/retinanet/retinanet_r50_gsca_fpn_1x_coco.py $NGPUS