MID_RUN_NAME=${1:-"llavanext-lora-omni-wsysprompt"}
CHECKPOINT=${2:-"checkpoints/llava_checkpoints_final/omni_model.bin"}
DEVICE=${3:-"2"}
IMG_FOLDER=${4:-"/data/metagen-data/v3/images/"}
BASE_MODEL="lmms-lab/llama3-llava-next-8b"
MODEL_NAME="llava_llama3_lora"

VISION_MODEL_VERSION="openai/clip-vit-large-patch14-336"

CUDA_VISIBLE_DEVICES=${DEVICE} python scripts/inference_demo_server.py \
    --lora_enable True --lora_r 16 --lora_alpha 32 --mm_projector_lr 2e-5 \
    --model_name_or_path ${BASE_MODEL} \
    --version llava_llama_3 \
    --data_path="" \
    --image_folder ${IMG_FOLDER} \
    --vision_tower ${VISION_MODEL_VERSION} \
    --mm_projector_type mlp2x_gelu \
    --mm_vision_select_layer -2 \
    --mm_use_im_start_end False \
    --mm_use_im_patch_token False \
    --group_by_modality_length True \
    --image_aspect_ratio anyres \
    --image_grid_pinpoints "[(336, 672), (672, 336), (672, 672), (1008, 336), (336, 1008)]" \
    --mm_patch_merge_type spatial_unpad \
    --bf16 True \
    --run_name $MID_RUN_NAME \
    --output_dir "checkpoints/${MID_RUN_NAME}/evaluate_demo" \
    --logging_steps 1 \
    --tf32 True \
    --model_max_length 32768 \
    --gradient_checkpointing True \
    --dataloader_num_workers 16 \
    --lazy_preprocess True \
    --report_to wandb \
    --attn_implementation sdpa \
    --checkpoint ${CHECKPOINT} \
    --num_processes 1 \
    --temperature 0 \
    --model_name ${MODEL_NAME} \
    --vocab_size_overwrite 128256 \
    --change_system_prompt True \
    --is_dslv3_format False

# You can delete the sdpa attn_implementation if you want to use flash attn
