from .util import list_all, open_file
import pandas as pd
import json
from tqdm import tqdm

def last_line(stream):
    return [l.strip() for l in stream.strip().split('\n')][-1]

def exit_reason(rcode):
    if rcode == 0:
        return 'OKAY'
    elif rcode == 1:
        return 'ABNORMAL'
    elif rcode == -9:
        return 'SIGKILL'
    elif rcode == -11:
        return 'SEGFAULT'
    else:
        return 'OTHER'

def sim_stage(stdout):
    if 'Failed to evaluate node' in stdout:
        return 'Node Eval Failed'
    elif 'using solvePeriodic2' in stdout:
        return 'Solver'
    elif 'Post remeshing' in stdout:
        return 'Post Remeshing'
    elif 'Computing Material Matrix... Done' in stdout:
        return 'Done'
    else:
        return 'Other'

def format_results(results):
    return {
        'sim_success': results.get('gen_and_sim_success',None),
        'sim_stdout': last_line(results['gen_and_sim_stdout']) if 'gen_and_sim_stdout' in results else None,
        'sim_stderr': last_line(results['gen_and_sim_stderr']) if 'gen_and_sim_stderr' in results else None,
        'sim_rcode': results['gen_and_sim_return_code'] if 'gen_and_sim_return_code' in results else None,
        'valid':  results['contiguous_and_periodic'] if 'contiguous_and_periodic' in results else False,
        'program': '/'.join(results['logdata']['src'].split('/')[6:]) if 'src' in results['logdata'] else None,
        'src': results['logdata']['src'] if 'logdata' in results else None,
        'sim_exit': exit_reason(results['gen_and_sim_return_code']) if 'gen_and_sim_return_code' in results else None,
        'sim_stage': sim_stage(last_line(results['gen_and_sim_stdout'])) if 'gen_and_sim_stdout' in results else None,
        'count': 1

    }

def summarize_generation(data_root):
    all_result_locations = [p for p in list_all(data_root, False) if 'processing_results.json' in p]
    results = []
    for uri in tqdm(all_result_locations):
        with open_file(uri) as f:
            results.append(json.load(f))
    summarization = pd.DataFrame.from_records([format_results(r) for r in results])
    return summarization
