from . import procmeta_nodes as pmn
from . import procmeta_graph as pmg
import numpy as np

test_graph_construction = True
test_individual_node_defs = False

if test_graph_construction:
    print("\n======================\nGRAPH CONSTRUCTION TEST\n======================")
    sr = pmg.ProcMetaGraph()

    v1 = sr.add_vertex(np.array([0.0, 0.0, 0.0]))
    v2 = sr.add_vertex(np.array([0.5, 0.5, 0.5]))
    e1 = sr.add_edge_chain([v1, v2], False)
    l1 = sr.add_line_uniformThickness([e1], 0.03)
    m1 = sr.add_mirror(l1, np.array([0.5, 0.5, 0.5]), np.array([1.0, 0.0, 0.0]), True)
    m2 = sr.add_mirror(m1, np.array([0.5, 0.5, 0.5]), np.array([0.0, 1.0, 0.0]), True)
    m3 = sr.add_mirror(m2, np.array([0.5, 0.5, 0.5]), np.array([0.0, 0.0, 1.0]), True)
    g1 = sr.add_group([m3])
    o1 = sr.add_object(g1, 64)
    vox1 = sr.add_voxel(o1)

    filename = "test_sr.json"
    sr.save_to_json(filename)
    print(f"Saved to {filename}")


if test_individual_node_defs:
    print("\n======================\nNODE DEFINITION TESTS\n======================")

    print(pmn.ProcMetaOpNode.__subclasses__())

    # TEST INDIVIDUAL NODE DEFINITIONS
    v1 = pmn.OpNode_Vertex(1, np.array([0.0,0.0,0.0]))
    print(v1)
    print(v1.get_proc_meta_description())

    e1 = pmn.OpNode_EdgeChain(1, [v1, v1], False)
    print(e1)
    print(e1.get_proc_meta_description())

    l1 = pmn.OpNode_Line(1, [e1], np.array([[0.0, 0.03], [1.0, 0.03]]))
    print(l1.get_proc_meta_description())

    m1 = pmn.OpNode_Mirror(1, l1, np.array([0.5, 0.5, 0.5]), np.array([1.0, 0.0, 0.0]), True)
    print(m1.get_proc_meta_description())

    g1 = pmn.OpNode_Group(1, [l1, m1])
    print(g1.get_proc_meta_description())

    o1 = pmn.OpNode_Object(1, g1, 64)
    print(o1.get_proc_meta_description())

    vox1 = pmn.OpNode_Voxel(1, o1)
    print(vox1.get_proc_meta_description())