"""
LLM specific formatting procedures

Inputs expect a common, unprocessed, conversation format:

[
    {
        'role': 'system' | 'user' | 'assistant',
        'content': 'string with images <[]> encapsulated as locations
    },
    ...
]

From these conversations we can produce:
- batch inputs for training
- batch inputs for LLM calling


"""

from .util import *
from copy import deepcopy

def format_for_llm(conversation: list, llm: LLM = LLM.GPT, encode_images=False):
    """
    Return a basic dictionary of messages (and possibly 'system' if needed)

    LLaVa outputs, in particular, will need further processing to separate
    out the images appropriately.
    """
    messages = deepcopy(conversation)
    if llm == LLM.NOVA:
        system_messages = [message['content'] for message in messages if message['role'] == 'system']
        system_content = []
        for message in system_messages:
            system_content.append(format_prompt_contents('content'))
        messages = [message for message in messages if message['role'] != 'system']
    if llm == LLM.O1:
        for message in messages:
            if message['role'] == 'system':
                message['role'] == 'developer'
    for message in messages:
        message['content'] = format_prompt_contents(message['content'], encode_images, llm)
    
    if llm == LLM.NOVA and len(system_content) > 0:
        return {
            'system': system_content,
            'messages': messages
        }
    return {
        'messages': messages
    }
