"""
Synthesis pipeline worker that starts up the data synthesis pipeline:

- reads in config with pass / reject formats
- copies files into position for running

Startup Procedure:

1. Load Configuration from arguments and write them to a config file for workers to read.
2. Find all generators and parse them to determine their parameters and parameter ranges,
store this to give to the integration worker.
3. Queue initial work: copy any raw materials over to to_process, and create augmentation
   lines for all generators: use default parameters for 
"""

import argparse
import os
import shutil

def run_startup():
    parser = argparse.ArgumentParser()
    parser.add_argument('-s', '--skip', nargs='+', default=[])
    parser.add_argument('-m', '--memory_limit', type=float, default=None, help='maximum memory usage in GB')
    parser.add_argument('-t', '--timeout', type=int, default=None, help='timeout per material in seconds')
    parser.add_argument('-d', '--base', type=str, default='/data', help='base directory for dataset generation')
    args = parser.parse_args()

    basedir = os.path.abspath(args)
    workdir = os.path.join(basedir, 'workspace')
    pgendir = os.path.join(workdir, 'generators', 'parametric')

    matdir = os.path.join(basedir, 'materials')

    

    succeded_materials = [p for p in os.listdir(matdir) if os.path.isdir(os.path.join(matdir, p))]
    failed_materials = [p for p in os.listdir(matdir) if os.path.isdir(os.path.join(matdir, p))]