description_system_prompt_template = """You are an assistant that generates detailed text descriptions for cellular metamaterials based on their DSL code and visual representations.

**DSL API Description:**

{api_description}
"""

augmentation_system_prompt_template = """You are an assistant that generates novel cellular metamaterial designs using the following DSL:

**DSL API Description:**

{api_description}

"""

augmentation_user_prompt_template = """**Task**
Describe and generate a new, valid metamaterial program combining patterning and structural features from the following metamaterials:

{materials}

**Output Format**
First output a text description of the material, then output the DSL program delimited by ```{lang} ```:

{{MATERIAL DESCRIPTION}}

```{lang}
{{DSL PROGRAM}}
```
"""

augmentation_material_template = """**Material {n}**
***Isometric Base Cell Renderings:***
- Angled (Front-Top-Left) View: <[{top_right}]>
- Top View: <[{top}]>
- Front View: <[{front}]>
- Right View: <[{right}]>
***Text Description:***
{description}
***DSL Code:***
```{lang}
{code}
```
"""

dsl_code_template = """```python
from metagen import *

def make_structure() -> Structure:
```"""

code_api_description = """Programs in our language are built in two stages: one that creates local geometric structure, and a second that patterns this structure throughout space. Each of these is further broken down into subparts.


==================================
    API description (Boilerplate)
==================================
This program must import the metagen package and define a function called "make_structure()", which takes no parameters and returns the final Structure object defined by the program. Specifically, the following boilerplate must be present: 

```python
from metagen import *

def make_structure() -> Structure:
```

==================================
    DSL description
==================================

======= Skeleton Creation ========
vertex(cpEntity, t)
    @description:
        Create a new vertex. This vertex is defined relative to its containing convex polytope (CP). It will only have an embedding in R3 once the CP has been embedded.
    @params:
        cpEntity    - an entity of a convex polytope (CP), referenced by the entity names.
        t           - [OPTIONAL] list of floats in range [0,1], used to interpolate to a specific position on the cpEntity.
                        If cpEntity is a corner, t is ignored.
                        If cpEntity is an edge, t must contain exactly 1 value. t is used for linear interpolation between the endpoints of cpEntity.
                        If cpEntity is a face, t must contain exactly 2 values. If cpEntity is a triangular face, t is used to interpolate via barycentric coordinates. If cpEntity is a quad face, bilinear interpolation is used.
                        
                        If the optional interpolant t is omitted for a non-corner entity, the returned point will be at the midpoint (for edge) or the centroid (for face) of the entity. Semantically, we encourage that t be excluded (1) if the structure would be invalid given a different non-midpoint t, or (2) if the structure would remain unchanged in the presence a different t (e.g., in the case of a conjugate TPMS, where only the entity selection matters).
    @returns:
        vertex      - the new vertex object 
    @example_usage:
        v0 = vertex(cuboid.edges.BACK_RIGHT, [0.5])
        v1 = vertex(cuboid.edges.TOP_LEFT)


Polyline(ordered_vertices)
    @description:
        Creates a piecewise-linear path along the ordered input vertices. All vertices must be referenced to the same CP (e.g., all relative to cuboid entities). The resulting path will remain a polyline in any structures that include it.
    @params:
        ordered_verts   - a list of vertices, in the order you'd like them to be traversed. A closed loop may be created by repeating the zeroth element at the end of the list. No other vertex may be repeated. Only simple paths are permitted.
    @returns:
        polyline        - the new polyline object
    @example_usage:
        p0 = Polyline([v2, v3])
        p0 = Polyline([v0, v1, v2, v3, v4, v5, v0])


Curve(ordered_vertices)
    @description:
        Creates a path along the ordered input vertices. This path will be smoothed at a later stage (e.g., to a Bezier curve), depending on the lifting procedures that are chosen. All input vertices must be referenced to the same CP (e.g., all relative to cuboid entities). 
    @params:
        ordered_verts   - a list of vertices, in the order you'd like them to be traversed. A closed loop may be created by repeating the zeroth element at the end of the list. No other vertex may be repeated. Only simple paths are permitted.
    @returns:
        polyline        - the new polyline object
    @example_usage:
        p0 = Curve([v2, v3])
        p0 = Curve([v0, v1, v2, v3, v4, v5, v0])

skeleton(entities)
    @description:
        Combines a set of vertices OR polylines/curves into a larger structure, over which additional information can be inferred. For example, within a skeleton, multiple open polylines/curves may string together to create a closed loop, a branched path, or a set of disconnected components.
    @params:
        entities        - a list of entities (vertices or polylines/curves) to be combined. A given skeleton must only have entities with the same dimension -- that is, it must consist of all points or all polylines/curves.
    @returns:
        skeleton        - the new skeleton object
    @example_usage:
        skel = skeleton([curve0, polyline1, curve2, polyline3])
        skel = skeleton([v0])


======= Tile Creation ========
Tile(skel, corner_positions)
    @description:
        Procedure to embed a copy of the skeleton in R^3 using the provided corner_positions, which correspond to the positions for each of the N corners of the skeleton's CP.
    @params:
        skel            - the skeleton entity (and, by inference, its CP) to embed in R^3
        corner_positions- a list of length N, where each entry is a list of 3 float values, specifying the corner positions of the CP.
    @returns:
        tile            - the new tile object
    @example_usage:
        s_tile_corners = [[0.5, 0.0, 0.0],
                          [0.0, 0.0, 0.0],
                          [0.5, 0.5, 0.0],
                          [0.0, 0.5, 0.0],
                          [0.5, 0.0, 0.5],
                          [0.0, 0.0, 0.5],
                          [0.5, 0.5, 0.5],
                          [0.0, 0.5, 0.5]]
        s_tile = Tile(s_skel, s_tile_corners)

======= Lifting Procedures ========
UniformBeams(skel, thickness)
    @description:
        Procedure to lift the input skeleton to a 3D volumetric structure by instantiating a beam of the given thickness centered along each polyline/curve of the input skeleton. The skeleton must contain only polylines and/or curves. The skeleton must not contain any standalone vertices.
    @params:
        skel            - the skeleton to lift
        thickness       - the diameter of the beams
    @returns:
        liftProc        - the new lift procedure
    @example_usage:
        liftProcedure = UniformBeams(tile, 0.03)

UniformDirectShell(skel, thickness)
    @description:
        Procedure to lift the input skeleton to a 3D volumetric structure by inferring a surface that conforms to the boundary provided by the input skeleton. The surface is given by a simple thin shell model: the resulting surface is incident on the provided boundary while minimizing a weighted sum of bending and stretching energies. The boundary is fixed, though it may be constructed with a mix of polylines and curves (which are first interpolated into a spline, then fixed as part of the boundary). The skeleton must contain a single closed loop composed of one or more polylines and/or curves. The skeleton must not contain any standalone vertices.
    @params:
        skel            - the skeleton to lift
        thickness       - the thickness of the shell. The final offset is thickness/2 to each side of the inferred surface.
    @returns:
        liftProc        - the new lift procedure
    @example_usage:
        liftProcedure = UniformDirectShell(c_tile, 0.1)

UniformTPMSShellViaConjugation(skel, thickness)
    @description:
        Procedure to lift the input skeleton to a 3D volumetric structure by inferring a triply periodic minimal surface (TPMS) that conforms to the boundary constraints provided by the input skeleton. The surface is computed via the conjugate surface construction method. The skeleton must contain a single closed loop composed of one or more polylines and/or curves. Each vertex in the polylines/curves must live on a CP edge, and adjacent vertex pairs must have a shared face. The skeleton must not contain any standalone vertices.
    @params:
        skel            - the skeleton to lift
        thickness       - the thickness of the shell. The final offset is thickness/2 to each side of the inferred surface.
    @returns:
        liftProc        - the new lift procedure
    @example_usage:
        liftProcedure = UniformTPMSShellViaConjugation(tile, 0.03)

UniformTPMSShellViaMixedMinimal(skel, thickness)
    @description:
        Procedure to lift the input skeleton to a 3D volumetric structure by inferring a triply periodic minimal surface (TPMS) that conforms to the boundary constraints provided by the input skeleton. The surface is computed via mean curvature flow. All polyline boundary regions are considered fixed, but any curved regions may slide within their respective planes in order to reduce surface curvature during the solve. The skeleton must contain a single closed loop composed of one or more polylines and/or curves. Each vertex in a curve must live on a CP edge, and adjacent vertex pairs must have a shared face. The skeleton must not contain any standalone vertices.
    @params:
        skel            - the skeleton to lift
        thickness       - the thickness of the shell. The final offset is thickness/2 to each side of the inferred surface.
    @returns:
        liftProc        - the new lift procedure
    @example_usage:
        liftProcedure = UniformTPMSShellViaMixedMinimal(tile, 0.03)

Spheres(skel, thickness)
    @description:
        Procedure to lift the input skeleton to a 3D volumetric structure by instantiating a sphere of the given radius centered at vertex p, for each vertex in the skeleton. The skeleton must only contain standalone vertices; no polylines or curves can be used.
    @params:
        skel            - the skeleton to lift
        thickness       - the sphere radius 
    @returns:
        liftProc        - the new lift procedure
    @example_usage:
        s_lift = Spheres(s_tile, 0.25)


======= Patterning Procedures ========
TetFullMirror()
    @description:
        Procedure which uses only mirrors to duplicate a tet-based tile such that it partitions R^3
    @params:
        N/A
    @returns:
        pat     - the patterning procedure
    @example_usage:
        pat = TetFullMirror()

TriPrismFullMirror()
    @description:
        Procedure which uses only mirrors to duplicate a triangular prism-based tile such that it partitions R^3
    @params:
        N/A
    @returns:
        pat     - the patterning procedure
    @example_usage:
        pat = TriPrismFullMirror()

OctantFullMirror()
    @description:
        Procedure which uses only mirrors to duplicate an octant tile (covering 1/8 of the unit cube) such that it partitions R^3.
    @params:
        N/A
    @returns:
        pat     - the patterning procedure
    @example_usage:
        pat = OctantFullMirror()

CuboidFullMirror()
    @description:
        Procedure which uses only mirrors to duplicate an axis-aligned cuboid tile such that it fills a unit cube,  such that it partitions R^3. Eligible cuboid CPs must be such that all dimensions are 1/(2^k) for some positive integer k.
    @params:
        N/A
    @returns:
        pat     - the patterning procedure
    @example_usage:
        pat = CuboidFullMirror()


Identity()
    @description:
        No-op patterning procedure.
    @params:
        N/A
    @returns:
        pat     - the patterning procedure
    @example_usage:
        pat = Identity()


======= Structure Procedures ========
Structure(tile, liftProcedure, pattern)
    @description:
        Combines local tile information the global patterning procedure and volumetric lifting operations to generate a volumetric 3D structure.
    @params:
        tile            - the tile object, which has (by construction) already been embedded in 3D space, along with the skeleton it contains.
        liftProcedure   - the lift procedure to apply to the tile's skeleton
        pattern         - the patterning sequence to apply to extend this tile throughout space
    @returns:
        structure       - the new structure object
    @example_usage:
        obj = Structure(tile, liftProcedure, pat)

Union(A, B)
    @description:
        Constructive solid geometry Boolean operation that computes the union of two input structures. The output of Union(A,B) is identical to Union(B,A)
    @params:
        A               - the first Structure to be unioned. This may be the output of Structure, Union, Subtract, or Intersect
        B               - the second Structure to be unioned. This may be the output of Structure, Union, Subtract, or Intersect
    @returns:
        structure       - the new structure object containing union(A,B)
    @example_usage:
        final_obj = Union(schwarzP_obj, Union(sphere_obj, beam_obj))

Subtract(A, B)
    @description:
        Constructive solid geometry Boolean operation that computes the difference (A - B) of two input structures. The relative input order is critical.
    @params:
        A               - the first Structure, from which B will be subtracted. This may be the output of Structure, Union, Subtract, or Intersect
        B               - the second Structure, to be subtracted from A. This may be the output of Structure, Union, Subtract, or Intersect
    @returns:
        structure       - the new structure object containing (A - B)
    @example_usage:
        final_obj = Subtract(c_obj, s_obj)

Intersect(A, B)
    @description:
        Constructive solid geometry Boolean operation that computes the intersection of two input structures, A and B. 
    @params:
        A               - the first Structure, which may be the output of Structure, Union, Subtract, or Intersect
        B               - the second Structure, which may be the output of Structure, Union, Subtract, or Intersect
    @returns:
        structure       - the new structure object containing the intersection of A and B
    @example_usage:
        final_obj = Intersect(c_obj, s_obj)




==================================
    Prebuilt Convex Polytopes
==================================
There are 3 prebuilt convex polytopes (CP) available for use: cuboid, triPrism, and tet. Each CP comprises a set of Entities, namely faces, edges and corners. For convenience, each individual entity can be referenced using the pattern <CP>.<entity_type>.<ENTITY_NAME>. For example, you can select a particular edge of the cuboid with the notation cuboid.edges.BOTTOM_RIGHT

The full list of entities in our predefined CPs are as follows:

tet.corners.{   BOTTOM_RIGHT,
                BOTTOM_LEFT,
                TOP_BACK,
                BOTTOM_BACK
            }
tet.edges.  {   BOTTOM_FRONT,
                TOP_LEFT,
                BACK,
                BOTTOM_RIGHT,
                TOP_RIGHT,
                BOTTOM_LEFT
            }
tet.faces.  {   BOTTOM,
                TOP,
                RIGHT,
                LEFT
            }


triPrism.corners.{FRONT_BOTTOM_LEFT,
                FRONT_TOP,
                FRONT_BOTTOM_RIGHT,
                BACK_BOTTOM_LEFT,
                BACK_TOP,
                BACK_BOTTOM_RIGHT
            }
triPrism.edges.{FRONT_LEFT,
                FRONT_RIGHT,
                FRONT_BOTTOM,
                BACK_LEFT,
                BACK_RIGHT,
                BACK_BOTTOM,
                BOTTOM_LEFT,
                TOP,
                BOTTOM_RIGHT
            }
triPrism.faces.{FRONT_TRI,
                BACK_TRI,
                LEFT_QUAD,
                RIGHT_QUAD,
                BOTTOM_QUAD
            }


cuboid.corners.{FRONT_BOTTOM_LEFT,
                FRONT_BOTTOM_RIGHT,
                FRONT_TOP_LEFT,
                FRONT_TOP_RIGHT,
                BACK_BOTTOM_LEFT,
                BACK_BOTTOM_RIGHT,
                BACK_TOP_LEFT,
                BACK_TOP_RIGHT
            }
cuboid.edges.{  FRONT_BOTTOM,
                FRONT_LEFT,
                FRONT_TOP,
                FRONT_RIGHT,
                BACK_BOTTOM,
                BACK_LEFT,
                BACK_TOP,
                BACK_RIGHT,
                BOTTOM_LEFT,
                TOP_LEFT,
                TOP_RIGHT,
                BOTTOM_RIGHT
            }
cuboid.faces.{  FRONT,
                BACK,
                TOP,
                BOTTOM,
                LEFT,
                RIGHT
            }

"""

graph_code_template = """```json
{ 
    "operations":[]
}
``` """

graph_api_description = """The following text describes a graph-based language that can be used to specify one unit cell of a tileable metamaterial.

At a high level, this language uses a four-step approach: (1) specify the skeleton of a small fundamental piece of the structure using lines and/or surfaces (we refer to the enclosing volume of this structure as a Fundamental Bounding Volume, or FBV), (2) assign a spatially varying thickness profile T(p) for each point p of the skeleton, (3) apply any transformations (e.g., mirroring, rotation) required to fill the tiling unit, and (4) realize the final volumetric object according to T(p). 

Each graph node performs an operation such as vertex creation, line/surface inference, mirroring, or skeleton thickening. Each node also has properties that control its behavior. By chaining and sequentially evaluating these nodes, we can form a variety of structures.

Materials are valid when they are periodic and contiguous. This is validated by tiling the unit cell 3 times in all dimensions, then checking that the tiled structure is periodic, and that there exists at least component that touches all boundaries of the tiled cell.


==================================
    API description
==================================
Each procedure is a json object with exactly one field named "operations"; this field contains a list. Thus, the outermost boilerplate looks like this: 

```json
{ 
    "operations":[]
}
``` 


Each element of the "operations" list is a dictionary that defines a single node (an "operation") of the graph. 

Each operation must contain a "name" field. The name is a unique string identifier for each node, comprising two parts: <operation type code><numeric id>. The type code indicates the type of node (e.g. "v" for vertex) while the id is an integer used to differentiate between multiple instances of the same node type. For example, two vertex nodes may have codes "v0" and "v1". This naming convention must be followed precisely.

The available nodes, their type codes, and their parameters are as follows: 

[VERTEX]
- Operation description: instantiates a vertex at the given position. 
- Operation type code: "v"
- Operation class: "Topology"
- Operation-specific parameters: 
    -- "position": position in 3D space. Generally within the unit cube with corners at (0,0,0) and (1,1,1) -- exceptions can occur. Given as a list of length 3, where each element is a float.
- Example dictionary:
{
    "name": "v0",
    "position": [0.5, 0.5, 0.5]
}


[EDGE CHAIN]
- Operation description: defines topological connections (paths) between vertices.
- Operation type code: "e"
- Operation class: "Topology"
- Operation-specific parameters:
    -- "smooth": boolean value for whether the edge chain should form a smooth curve, or whether it should remain a polyline as specified.
    -- "vertices": an ordered list of vertices (referenced by their name attribute) that should be connected to form the edge chain. The list must have at least 2 elements. The vertices must form a simple, continuously traversible path (no branches, repeated segments). A vertex may only appear twice if it is the first and last element; in that case, the edge chain will form a closed loop. Closed loops must include at least 3 distinct vertices.
- Example dictionary:
{
    "name": "e0",
    "smooth": false,
    "vertices": ["v0", "v1"]
}


[LINE]
- Operation description: specifies that the input edge chains should be instantiated as beams with a given thickness profile in the final structure.
- Operation type code: "l"
- Operation class: "Skeleton"
- Operation-specific fields:
    -- "edges": ordered list of one or more edge chains (referenced by their name attributes) that are continuously traversable, i.e., the end of one edge chain is the start of another, such that they form a simple, non-branching path (open or closed).
    -- "periodic": boolean dictating whether a line that intersects the unit cell should be interpolated with periodicity constraints in mind. Irrelevant for non-smooth edges.
    -- "thickness": ordered list of paired values that specify the thickness profile for the instantiated beam. The first element of each ordered pair is a float in the range [0,1], which specifies the parametrized position along the line. The second element of each ordered pair is a float value in the range [0,1] which specifies the thickness of the beam at the given parametrized position. The full thickness profile is linearly interpolated from these provided sample points. The list must have length of at least 2. 
- Example dictionary:
{
    "name": "l0",
    "edges": ["e0"],
    "periodic": false,
    "thickness": [[0.0, 0.03], [1.0, 0.03]]
}


[SURFACE]
- Operation description: infers a surface subject to the provided boundary and associated annotations/constraints
- Operation type code: "s"
- Operation class: "Skeleton"
- Operation-specific fields:
    -- "boundaries": ordered list of one or more edge chains (referenced by their name attributes) that collectively form a simple closed loop.
    -- "type": type of surface to construct over the boundaries (i.e., the algorithm to run). Specified as one of the following strings: "direct", "minimal" or "conjugate". Each type has restrictions on e.g. vertex positions and edge incidence on the BV:
        -- For direct surfaces, the user need only provide the energy weight, and a non-degenerate, simple, closed boundary loop over vertices located anywhere in the FBV. For conjugate and mixed-minimal surfaces, each sliding segment must lie on an FBV face. Mixedminimal surfaces permit vertices anywhere on an FBV face. Conjugate boundaries are more restricted.Specifically, all vertices must lie on FBV edges and form property-respecting configurations.
    -- "bv-type": only required for "conjugate" type surfaces. Specified as one of the following strings: "aabb", "prism", "tet", or "custom". Each string indicates a default instantiation -- e.g. for "aabb", it will create an octant FBV with [0]^3 and [0.5]^3 as the extreme corners. If a different variant is desired, you must use a custom bv.
    -- "bv": only required for "conjugate" type surfaces. Corner points of the bv. Only required for custom bv. 
    -- "thickness": optional. Specifies the thickness values of the surface at a set of handle points given by a UV parametrization of the surface. Parametrization computed using ARAP, and values extrapolated over the whole surface using BBW over the handle positions/values. Given as a list of lists: each inner list is of length three, with the first/second element providing a UV coordinate and the third element providing the thickness value at that point.
    -- "sample-dist": optional, very rarely used. Influences resolution of the meshing procedures. 
    -- "conj-angle": Only relevant for "conjugate" type surfaces, and even then, just use a single float valued 0.0. This was a different way to specify an associate family transformation, but not fully implemented; abandoned in favor of AF node.
- Example dictionaries:
{
    "name": "s0",
    "boundaries": ["e0"],
    "type": "direct"
},
{
    "boundaries": ["e0"],
    "bv-type": "aabb",
    "conj-angle": 0.0,
    "name": "s0",
    "thickness": [
        [0.47435665627426066, 0.7356061468962897, 0.035],
        [0.6583471502009016, 0.3634928169815335, 0.05],
        [0.32896975197805, 0.3955758684789163, 0.01]
    ],
    "type": "direct"
},
{
    "name": "s0",
    "boundaries": ["e0"],
    "bv-type": "aabb",
    "conj-angle": 0.0,
    "type": "conjugate"
},
{
    "boundaries": ["e0"],
    "bv": [
        [0.0, 0.0, 0.0],
        [0.5, 0.0, 0.0],
        [0.5, 0.0, 0.5],
        [0.5, 0.5, 0.5]
    ],
    "bv-type": "custom",
    "name": "s0",
    "type": "conjugate"
},
{
    "name": "s0",
    "boundaries": ["e0", "e1", "e2", "e3"],
    "type": "minimal"
},


[DUAL SURFACE]
- Operation description: constructs the dual/conjugate surface of the provided input surface
- Operation type code: "dual"
- Operation class: "Skeleton"
- Operation-specific fields:
    -- "src": the surface node (referenced by its name attribute) whose dual to obtain. Must be a conjugate surface.
- Example dictionary:
{
    "name": "dual0",
    "src": "s0"
}


[ASSOCIATE FAMILY]
- Operation description: extracts a member of the associate family of surfaces s0 and s1, with the resulting surface given by cos(angle)*s0 + sin(angle)*s1. Surfaces s0 and s1 must be conjugate to one another -- e.g., s0 came from the "conjugate" surface node, and s1 is the result of a dual node applied on s0. The inputs can already have transforms applied, assuming that the meshes are compatible (eg, an identical number of appropriate transforms have been applied to each of the inputs)
- Operation type code: "af"
- Operation class: "Skeleton"
- Operation-specific fields:
    -- "s0": surface node (referenced by its name attribute) to be treated as the primary surface (this surface appears untouched if the af angle is 0 deg)
    -- "s1": surface node (referenced by its name attribute) to be treated as the dual surface (this appears untouched if the af angle is 90 deg)
    -- "angle": interpolation angle to be applied to the two surfaces. Provided in degrees.
- Example dictionary:
{
    "angle": 51.854,
    "name": "af1",
    "s0": "mirror6",
    "s1": "t7"
},


[MIRROR]
- Operation description: mirrors the input structure across the provided plane (in the direction of the provided plane normal).
- Operation type code: "mirror"
- Operation class: "Skeleton"
- Operation-specific fields:
    -- "src": node to be mirrored (referenced by its name attribute). Only one node is allowed, and it must be part of the Skeleton class.
    -- "copy": boolean value. If false, the input geometry itself is mirrored across the plane. If true, a copy of the geometry is made and mirrored; the input geometry remains untouched.
    -- "plane": a list of 6 float values that specify the mirror plane in point-normal format. The first 3 values specify a 3d position on the plane; all values must be in the range [0, 1]. The remaining 3 values specify the normal vector of the plane, pointing in the direction of the mirror activity. The normal does not need to be normalized to unit length.
- Example dictionary:
{
    "name": "mirror0",
    "src": "g0",
    "copy": true,
    "plane": [0.5, 0.5, 0.5, 1.0, 0.0, 0.0]
}


[TRANSFORM]
- Operation description: applies affine transformations (scale, rotate, translate) to the provided input structure.
- Operation type code: "t"
- Operation class: "Skeleton"
- Operation-specific fields:
    -- "src": node containing the content to be transformed (referenced by its name attribute). Only one node is allowed, and it must be part of the Skeleton class.
    -- "r-axis": axis of rotation. Given as a list of length 3, where each element is a float.
    -- "r-angle": Angle (in degrees) to rotate the input about the provided rotation axis. Given as a float.
    -- "t": translation vector. Given as a list of length 3, where each element is a float.
    -- "origin": Position in 3D space, to be considered the origin for all operations in this transform node (including the point along the rotation axis). Given as a list of length 3, where each element is a float.
    -- "s": Scaling factor in the x,y,z directions. Given as a list of length 3, where each element is a float.
    -- "copy": boolean value. If false, the input geometry itself is transformed. If true, a copy of the geometry is made and transformed; the input geometry remains untouched.
- Example dictionary:
{
    "name": "t0",
    "copy": true,
    "origin": [0.125, 0.125, 0.125],
    "r-angle": 90.0,
    "r-axis": [1.0, 0.0, 0.0],
    "s": [1.0, 1.0, 1.0],
    "src": "mirror0",
    "t": [0.0, 0.0, 0.0]
}

[GROUP]
- Operation description: groups a set of input skeleton nodes, so they can be manipulated as a single unit by subsequent operations.
- Operation type code: "g"
- Operation class: "Skeleton"
- Operation-specific fields:
    -- "inputs": list of nodes to group (referenced by their name attributes). All input operations must be part of the Skeleton class.
- Example dictionary:
{
    "name": "g0",
    "inputs": ["l0"]
}


[OBJECT]
- Operation description: thickens the input skeletons to form a solid object. Every valid graph must have at least 1 Object node.
- Operation type code: "object"
- Operation class: "Solid"
- Operation-specific fields:
    -- "src": node to be thickened (referenced by its name attribute). Only one node is allowed, and it must be part of the Skeleton class.
    -- "resolution": integer value specifying the resolution of the spatial grid for the signed distance field / marching cubes algorithm used for thickening. Typical values are 64, 100, or 128.
    -- "extrusion-method": optional parameter, specifying whether to use spherical thickening (0) or normal extrusion (1). Default is 0 (spherical).
- Example dictionary:
{
    "name": "object0",
    "src": "mirror5",
    "resolution": 64,
    "extrusion-method": 0
}

[CSG BOOLEAN]
- Operation description: performs a CSG boolean operation (union, intersect, difference) on a pair of objects
- Operation type code: "boolean"
- Operation class: "Solid"
- Operation-specific fields:
    -- "src": list of 2 nodes (referenced by their name attributes) to be booleaned. Each node must be either an object or a boolean object.
    -- "opt": the boolean operation to perform. 0 is union, 1 is intersection, 2 is difference. In cases where order matters, the zeroth element of the src list is treated as the first operand (e.g., in case 2, the operation is src[0] - src[1] )
- Example dictionary:
{
    "name": "boolean0",
    "opt": 2,
    "src": ["object0", "object1"]
}

[VOXELIZE]
- Operation description: voxelizes the input Object using the grid specified in the input Object node. Every valid graph must have exactly 1 Voxelize node.
- Operation type code: "vox"
- Operation class: "Solid"
- Operation-specific fields:
    -- "src": Object node to be thickened (referenced by its name attribute). Only one node is allowed, and it must be an Object operation node.
    -- "E": Young's modulus of the base material (Pa), to be used in any subsequent property evaluations.
    -- "nu": Poisson's ratio of the base material (unitless), to be used in any subsequent property evaluations.
    -- "pho": density of the base material (kg/m^3), to be used in any subsequent property evaluations. [should've been rho, but the typo became too pervasive to fix]
- Example dictionary:
{
    "name": "vox1",
    "src": "object0",
    "E": 1.0,
    "nu": 0.45,
    "pho": 1.0
}

[MATERIAL MATRIX]
- Operation description: computes the 6x6 material matrix for the given input structure.
- Operation type code: "mat"
- Operation class: "MaterialProps"
- Operation-specific fields:
    -- "src": the voxel node to simulate (referenced by its name attribute)
- Example dictionary:
{
    "name": "mat0",
    "src": "vox1"
}
"""

description_generation_prompt_template = """**Instructions:**

Provide a comprehensive and precise text description of the cellular metamaterial's geometry and structure. The description should accurately reflect the features shown in the DSL code and the provided views. Ensure that the description is clear and detailed enough to serve as training data for a vision-language model, but DO NOT leak any code or variable names into the description.

**DSL Code:**

{dsl_code}

**Rendered Views (Isometric Renders):**
- Top: <[{top}]>
- Front: <[{front}]>
- Right: <[{right}]>
- Angled (Front-Top-Right): <[{top_right}]>

**Example Descriptions:**
- "Four beams that extend from the center of the unit cell to opposing corners. The beams have a non uniform thickness, and are thicker at their middles than their ends."
- "A combination of hollow spheres, one at the center of the cell and one octant of a sphere at each unit cell corner, with the sphere centers at the cell corners. The material exhibits mirror symmetry between each of the unit cell octants."
- "A 4x4x4 lattice of X-shaped beams spans the cell, and is interpenetrated by a weave of curved beams in the horizontal direction between each row and column of Xs. The lattice exhibits 4-fold translational symmetric along every dimension, and the weave alternates being above/below and in-front of / behind the lattice beams in each row / column."
"""

universal_system_prompt_template = """You are an expert metamaterials assistant that generates and analyzes cellular metamaterial designs based on material properties, images, and programatic definitions in a metamaterial DSL.


# Procedural Description in a Metamaterial DSL:

{api_description}

# Material Analysis:
You can analyze the density and elasticity properties of metamaterials. All metamaterials are assumed to be constucted from an isotropic base material with Poisson's ratio nu = 0.45.
The Young's Modulus of this base material is not specified, instead, the elastic moduli of the metamaterials -- Young's Modulus (E), Bulk Modulus (K), and Shear Modulus (G), are expressed relative to the base material Young's modulus (E_base). This means, for example, that relative Young's Moduli can range from 0 to 1. The material properties you can analyze are:

- E: Young's Modulus, Voigt-Reuss-Hill (VRH) average, relative to E_base
- K: Bulk modulus (VRH average), relative to E_base
- G: Shear Modulus (VRH average), relative to E_base
- nu: isotropic Poisson ratio (VRH)
- rho : density relative to the base material (equivalently, volume fraction)

# Material Images:

Images of metamaterials depict a base cell of the material, rendered in yellow, from four viewpoints:

- from the top
- from the front side
- from the right side
- from an angle at the upper-front-right

# Tasks:

You will be asked to perform several kinds of tasks:

- synthesis: take several materials and generate new materials by combining features and ideas from each to create a new, unique material
- prediction: given an image and or DSL procedure, predict its physical properties, rounded to the nearest decimal (.1 or .01)
- generation: given material properties and/or an image, generate a DSL procedure to create a material with those properties
"""


## Task Templates

# Prediction Tasks

predict_output_template = """
```json
{{
    "E": {E},
    "K": {K},
    "G": {G},
    "nu": {nu},
    "rho": {rho}
}}
```
"""

predict_from_image_template = """
# Task:
Analyze these views of a metamaterial, and predict its material properties.

# Inputs:

**Rendered Views:**
- Top: <[{top}]>
- Front: <[{front}]>
- Right: <[{right}]>
- Angled (Front-Top-Right): <[{top_right}]>

# Output Format:

Output a json object where the keys are material property names, and the values
are the predicted material properties. Predict these properties (keys):
- "E" : Young's Modulus in x relative to E_base to the nearest 0.1
- "K" : Bulk modulus relative to E_base to the nearest 0.5
- "G": Shear modulus relative to E_base to the nearest 0.05
- "nu": Isotropic Poisson ratio to the nearest 0.1
- "rho" : Relative Density (Volume Fraction) to the nearest 0.1
"""

predict_from_code_template = """
# Task:
Analyze this metamaterial DSL procedure, and predict its material properties.

# Inputs:

**DSL Procedure:**

{code}

# Output Format:

Output a json object where the keys are material property names, and the values
are the predicted material properties. Predict these properties (keys):
- "E" : Young's Modulus in x relative to E_base to the nearest 0.1
- "K" : Bulk modulus relative to E_base to the nearest 0.5
- "G": Shear modulus relative to E_base to the nearest 0.05
- "nu": Isotropic Poisson ratio to the nearest 0.1
- "rho" : Relative Density (Volume Fraction) to the nearest 0.1
"""

predict_from_image_and_code_template = """
# Task:
Analyze these views of a metamaterial, and the metamaterial DSL procedure, and predict its material properties.

# Inputs:

**DSL Procedure:**

{code}

**Rendered Views:**
- Top: <[{top}]>
- Front: <[{front}]>
- Right: <[{right}]>
- Angled (Front-Top-Right): <[{top_right}]>

# Output Format:

Output a json object where the keys are material property names, and the values
are the predicted material properties. Predict these properties (keys):
- "E" : Young's Modulus in x relative to E_base to the nearest 0.1
- "K" : Bulk modulus relative to E_base to the nearest 0.5
- "G": Shear modulus relative to E_base to the nearest 0.05
- "nu": Isotropic Poisson ratio to the nearest 0.1
- "rho" : Relative Density (Volume Fraction) to the nearest 0.1
"""

# Generation Templates

generate_output_template = """
{code}
"""

generate_from_image_template = """
# Task:
Analyze these views of a metamaterial, then generate a metamaterial DSL procedure to reproduce it.

# Inputs:

**Rendered Views:**
- Top: <[{top}]>
- Front: <[{front}]>
- Right: <[{right}]>
- Angled (Front-Top-Right): <[{top_right}]>

# Output Format:

Generate a metamaterial DSL procedure within a {lang} code block:

{lang_template}

"""

generate_from_properties_template = """
# Task:

Create a metamaterial DSL procedure that makes a material with the given properties:

# Input:

**Material Properties:**
- Relative Young's Modulus: E = {E}
- Relative Bulk Modulus: K = {K}
- Relative Shear Moduli: G = {G}
- Isotropic Poison Ratio: nu = {nu}
- Relative Density: rho = {rho}

# Output Format:

Generate a metamaterial DSL procedure within a {lang} code block:

{lang_template}

"""

generate_from_image_and_properties_template = """
# Task:
Analyze these views of a metamaterial, then generate a metamaterial DSL procedure to reproduces it and has the given material properties.

# Inputs:

**Rendered Views:**
- Top: <[{top}]>
- Front: <[{front}]>
- Right: <[{right}]>
- Angled (Front-Top-Right): <[{top_right}]>

**Material Properties:**
- Relative Young's Modulus: E = {E}
- Relative Bulk Modulus: K = {K}
- Relative Shear Moduli: G = {G}
- Isotropic Poison Ratio: nu = {nu}
- Relative Density: rho = {rho}

# Output Format:

Output a json object where the keys are material property names, and the values
are the predicted material properties. Predict these properties (keys):
- "E" : Young's Modulus in x relative to E_base to the nearest 0.1
- "K" : Bulk modulus relative to E_base to the nearest 0.5
- "G": Shear modulus relative to E_base to the nearest 0.05
- "nu": Isotropic Poisson ratio to the nearest 0.1
- "rho" : Relative Density (Volume Fraction) to the nearest 0.1

# Output Format:

Generate a metamaterial DSL procedure within a {lang} code block:

{lang_template}

"""

# Hybridization Tasks

synthesize_from_code_template = """
# Task:

Analyze the following metamaterial DSL procedures, then synthesize several new metamaterial designs that combines elements, structures, and ideas from them, while being unique and distinct, as well as the validity requirement of having at least one contiguous and periodic connected components

# Input Materials:

{materials}

# Output Format:

Output a metamaterial DSL procedures, each within its own code block

New Material 1:
{lang_template}

New Material 2:
{lang_template}

...
"""

synthesize_from_code_and_renders_template = """
# Task:

Analyze the following metamaterial DSL procedures and renders, then synthesize several new metamaterial designs that combines elements, structures, and ideas from them, while being unique and distinct, as well as the validity requirement of having at least one contiguous and periodic connected components

# Input Materials:

{materials}

# Output Format:

Output a metamaterial DSL procedures, each within its own code block

New Material 1:
{lang_template}

New Material 2:
{lang_template}

...
"""

parent_code_and_render_template = """
**Example Material**

Procedure:
```{lang}
{code}
```

Rendered Views:
- Top: <[{top}]>
- Front: <[{front}]>
- Right: <[{right}]>
- Angled (Front-Top-Right): <[{top_right}]>

"""

parent_code_template = """
**Example Material**

Procedure:
```{lang}
{code}
```

Rendered Views:
- Top: <[{top}]>
- Front: <[{front}]>
- Right: <[{right}]>
- Angled (Front-Top-Right): <[{top_right}]>

"""

metagen_dsl_api = """

CuboidFullMirror()
TetFullMirror()

"""