DATA_OPTS = {
    'mnist': {
        'sz': 28,
        'ch': 1,
        'labels': {
            0: '0',
            1: '1',
            2: '2',
            3: '3',
            4: '4',
            5: '5',
            6: '6',
            7: '7',
            8: '8',
            9: '9',
        },
        'dataset': 'MNIST',
        'plot_size': 3,
        'plot_cmap': 'hot',
    },
    'mnistf': {
        'sz': 28,
        'ch': 1,
        'labels': {
            0: 't-shirt',
            1: 'trouser',
            2: 'pullover',
            3: 'dress',
            4: 'coat',
            5: 'sandal',
            6: 'shirt',
            7: 'sneaker',
            8: 'bag',
            9: 'ankle boot',
        },
        'dataset': 'FashionMNIST',
        'plot_size': 3,
        'plot_cmap': 'hot',
    },
    'cifar10': {
        'sz': 32,
        'ch': 3,
        'norm_m': [0.4914, 0.4822, 0.4465],
        'norm_v': [0.2471, 0.2435, 0.2616],
        'labels': {
            0: 'airplane',
            1: 'automobile',
            2: 'bird',
            3: 'cat',
            4: 'deer',
            5: 'dog',
            6: 'frog',
            7: 'horse',
            8: 'ship',
            9: 'truck',
        },
        'dataset': 'CIFAR10',
        'plot_size': 3,
        'plot_cmap': None,
    },
    'imagenet': {
        'sz': 224,
        'ch': 3,
        'norm_m': [0.485, 0.456, 0.406],
        'norm_v': [0.229, 0.224, 0.225],
        'labels': {
            0: 'tench, tinca tinca',
            1: 'goldfish, carassius auratus',
            2: 'great white shark, white shark, man-eater, man-eating shark, carcharodon carcharias',
            3: 'tiger shark, galeocerdo cuvieri',
            4: 'hammerhead, hammerhead shark',
            5: 'electric ray, crampfish, numbfish, torpedo',
            6: 'stingray',
            7: 'cock',
            8: 'hen',
            9: 'ostrich, struthio camelus',
            10: 'brambling, fringilla montifringilla',
            11: 'goldfinch, carduelis carduelis',
            12: 'house finch, linnet, carpodacus mexicanus',
            13: 'junco, snowbird',
            14: 'indigo bunting, indigo finch, indigo bird, passerina cyanea',
            15: 'robin, american robin, turdus migratorius',
            16: 'bulbul',
            17: 'jay',
            18: 'magpie',
            19: 'chickadee',
            20: 'water ouzel, dipper',
            21: 'kite',
            22: 'bald eagle, american eagle, haliaeetus leucocephalus',
            23: 'vulture',
            24: 'great grey owl, great gray owl, strix nebulosa',
            25: 'european fire salamander, salamandra salamandra',
            26: 'common newt, triturus vulgaris',
            27: 'eft',
            28: 'spotted salamander, ambystoma maculatum',
            29: 'axolotl, mud puppy, ambystoma mexicanum',
            30: 'bullfrog, rana catesbeiana',
            31: 'tree frog, tree-frog',
            32: 'tailed frog, bell toad, ribbed toad, tailed toad, ascaphus trui',
            33: 'loggerhead, loggerhead turtle, caretta caretta',
            34: 'leatherback turtle, leatherback, leathery turtle, dermochelys coriacea',
            35: 'mud turtle',
            36: 'terrapin',
            37: 'box turtle, box tortoise',
            38: 'banded gecko',
            39: 'common iguana, iguana, iguana iguana',
            40: 'american chameleon, anole, anolis carolinensis',
            41: 'whiptail, whiptail lizard',
            42: 'agama',
            43: 'frilled lizard, chlamydosaurus kingi',
            44: 'alligator lizard',
            45: 'gila monster, heloderma suspectum',
            46: 'green lizard, lacerta viridis',
            47: 'african chameleon, chamaeleo chamaeleon',
            48: 'komodo dragon, komodo lizard, dragon lizard, giant lizard, varanus komodoensis',
            49: 'african crocodile, nile crocodile, crocodylus niloticus',
            50: 'american alligator, alligator mississipiensis',
            51: 'triceratops',
            52: 'thunder snake, worm snake, carphophis amoenus',
            53: 'ringneck snake, ring-necked snake, ring snake',
            54: 'hognose snake, puff adder, sand viper',
            55: 'green snake, grass snake',
            56: 'king snake, kingsnake',
            57: 'garter snake, grass snake',
            58: 'water snake',
            59: 'vine snake',
            60: 'night snake, hypsiglena torquata',
            61: 'boa constrictor, constrictor constrictor',
            62: 'rock python, rock snake, python sebae',
            63: 'indian cobra, naja naja',
            64: 'green mamba',
            65: 'sea snake',
            66: 'horned viper, cerastes, sand viper, horned asp, cerastes cornutus',
            67: 'diamondback, diamondback rattlesnake, crotalus adamanteus',
            68: 'sidewinder, horned rattlesnake, crotalus cerastes',
            69: 'trilobite',
            70: 'harvestman, daddy longlegs, phalangium opilio',
            71: 'scorpion',
            72: 'black and gold garden spider, argiope aurantia',
            73: 'barn spider, araneus cavaticus',
            74: 'garden spider, aranea diademata',
            75: 'black widow, latrodectus mactans',
            76: 'tarantula',
            77: 'wolf spider, hunting spider',
            78: 'tick',
            79: 'centipede',
            80: 'black grouse',
            81: 'ptarmigan',
            82: 'ruffed grouse, partridge, bonasa umbellus',
            83: 'prairie chicken, prairie grouse, prairie fowl',
            84: 'peacock',
            85: 'quail',
            86: 'partridge',
            87: 'african grey, african gray, psittacus erithacus',
            88: 'macaw',
            89: 'sulphur-crested cockatoo, kakatoe galerita, cacatua galerita',
            90: 'lorikeet',
            91: 'coucal',
            92: 'bee eater',
            93: 'hornbill',
            94: 'hummingbird',
            95: 'jacamar',
            96: 'toucan',
            97: 'drake',
            98: 'red-breasted merganser, mergus serrator',
            99: 'goose',
            100: 'black swan, cygnus atratus',
            101: 'tusker',
            102: 'echidna, spiny anteater, anteater',
            103: 'platypus, duckbill, duckbilled platypus, duck-billed platypus, ornithorhynchus anatinus',
            104: 'wallaby, brush kangaroo',
            105: 'koala, koala bear, kangaroo bear, native bear, phascolarctos cinereus',
            106: 'wombat',
            107: 'jellyfish',
            108: 'sea anemone, anemone',
            109: 'brain coral',
            110: 'flatworm, platyhelminth',
            111: 'nematode, nematode worm, roundworm',
            112: 'conch',
            113: 'snail',
            114: 'slug',
            115: 'sea slug, nudibranch',
            116: 'chiton, coat-of-mail shell, sea cradle, polyplacophore',
            117: 'chambered nautilus, pearly nautilus, nautilus',
            118: 'dungeness crab, cancer magister',
            119: 'rock crab, cancer irroratus',
            120: 'fiddler crab',
            121: 'king crab, alaska crab, alaskan king crab, alaska king crab, paralithodes camtschatica',
            122: 'american lobster, northern lobster, maine lobster, homarus americanus',
            123: 'spiny lobster, langouste, rock lobster, crawfish, crayfish, sea crawfish',
            124: 'crayfish, crawfish, crawdad, crawdaddy',
            125: 'hermit crab',
            126: 'isopod',
            127: 'white stork, ciconia ciconia',
            128: 'black stork, ciconia nigra',
            129: 'spoonbill',
            130: 'flamingo',
            131: 'little blue heron, egretta caerulea',
            132: 'american egret, great white heron, egretta albus',
            133: 'bittern',
            134: 'crane',
            135: 'limpkin, aramus pictus',
            136: 'european gallinule, porphyrio porphyrio',
            137: 'american coot, marsh hen, mud hen, water hen, fulica americana',
            138: 'bustard',
            139: 'ruddy turnstone, arenaria interpres',
            140: 'red-backed sandpiper, dunlin, erolia alpina',
            141: 'redshank, tringa totanus',
            142: 'dowitcher',
            143: 'oystercatcher, oyster catcher',
            144: 'pelican',
            145: 'king penguin, aptenodytes patagonica',
            146: 'albatross, mollymawk',
            147: 'grey whale, gray whale, devilfish, eschrichtius gibbosus, eschrichtius robustus',
            148: 'killer whale, killer, orca, grampus, sea wolf, orcinus orca',
            149: 'dugong, dugong dugon',
            150: 'sea lion',
            151: 'chihuahua',
            152: 'japanese spaniel',
            153: 'maltese dog, maltese terrier, maltese',
            154: 'pekinese, pekingese, peke',
            155: 'shih-tzu',
            156: 'blenheim spaniel',
            157: 'papillon',
            158: 'toy terrier',
            159: 'rhodesian ridgeback',
            160: 'afghan hound, afghan',
            161: 'basset, basset hound',
            162: 'beagle',
            163: 'bloodhound, sleuthhound',
            164: 'bluetick',
            165: 'black-and-tan coonhound',
            166: 'walker hound, walker foxhound',
            167: 'english foxhound',
            168: 'redbone',
            169: 'borzoi, russian wolfhound',
            170: 'irish wolfhound',
            171: 'italian greyhound',
            172: 'whippet',
            173: 'ibizan hound, ibizan podenco',
            174: 'norwegian elkhound, elkhound',
            175: 'otterhound, otter hound',
            176: 'saluki, gazelle hound',
            177: 'scottish deerhound, deerhound',
            178: 'weimaraner',
            179: 'staffordshire bullterrier, staffordshire bull terrier',
            180: 'american staffordshire terrier, staffordshire terrier, american pit bull terrier, pit bull terrier',
            181: 'bedlington terrier',
            182: 'border terrier',
            183: 'kerry blue terrier',
            184: 'irish terrier',
            185: 'norfolk terrier',
            186: 'norwich terrier',
            187: 'yorkshire terrier',
            188: 'wire-haired fox terrier',
            189: 'lakeland terrier',
            190: 'sealyham terrier, sealyham',
            191: 'airedale, airedale terrier',
            192: 'cairn, cairn terrier',
            193: 'australian terrier',
            194: 'dandie dinmont, dandie dinmont terrier',
            195: 'boston bull, boston terrier',
            196: 'miniature schnauzer',
            197: 'giant schnauzer',
            198: 'standard schnauzer',
            199: 'scotch terrier, scottish terrier, scottie',
            200: 'tibetan terrier, chrysanthemum dog',
            201: 'silky terrier, sydney silky',
            202: 'soft-coated wheaten terrier',
            203: 'west highland white terrier',
            204: 'lhasa, lhasa apso',
            205: 'flat-coated retriever',
            206: 'curly-coated retriever',
            207: 'golden retriever',
            208: 'labrador retriever',
            209: 'chesapeake bay retriever',
            210: 'german short-haired pointer',
            211: 'vizsla, hungarian pointer',
            212: 'english setter',
            213: 'irish setter, red setter',
            214: 'gordon setter',
            215: 'brittany spaniel',
            216: 'clumber, clumber spaniel',
            217: 'english springer, english springer spaniel',
            218: 'welsh springer spaniel',
            219: 'cocker spaniel, english cocker spaniel, cocker',
            220: 'sussex spaniel',
            221: 'irish water spaniel',
            222: 'kuvasz',
            223: 'schipperke',
            224: 'groenendael',
            225: 'malinois',
            226: 'briard',
            227: 'kelpie',
            228: 'komondor',
            229: 'old english sheepdog, bobtail',
            230: 'shetland sheepdog, shetland sheep dog, shetland',
            231: 'collie',
            232: 'border collie',
            233: 'bouvier des flandres, bouviers des flandres',
            234: 'rottweiler',
            235: 'german shepherd, german shepherd dog, german police dog, alsatian',
            236: 'doberman, doberman pinscher',
            237: 'miniature pinscher',
            238: 'greater swiss mountain dog',
            239: 'bernese mountain dog',
            240: 'appenzeller',
            241: 'entlebucher',
            242: 'boxer',
            243: 'bull mastiff',
            244: 'tibetan mastiff',
            245: 'french bulldog',
            246: 'great dane',
            247: 'saint bernard, st bernard',
            248: 'eskimo dog, husky',
            249: 'malamute, malemute, alaskan malamute',
            250: 'siberian husky',
            251: 'dalmatian, coach dog, carriage dog',
            252: 'affenpinscher, monkey pinscher, monkey dog',
            253: 'basenji',
            254: 'pug, pug-dog',
            255: 'leonberg',
            256: 'newfoundland, newfoundland dog',
            257: 'great pyrenees',
            258: 'samoyed, samoyede',
            259: 'pomeranian',
            260: 'chow, chow chow',
            261: 'keeshond',
            262: 'brabancon griffon',
            263: 'pembroke, pembroke welsh corgi',
            264: 'cardigan, cardigan welsh corgi',
            265: 'toy poodle',
            266: 'miniature poodle',
            267: 'standard poodle',
            268: 'mexican hairless',
            269: 'timber wolf, grey wolf, gray wolf, canis lupus',
            270: 'white wolf, arctic wolf, canis lupus tundrarum',
            271: 'red wolf, maned wolf, canis rufus, canis niger',
            272: 'coyote, prairie wolf, brush wolf, canis latrans',
            273: 'dingo, warrigal, warragal, canis dingo',
            274: 'dhole, cuon alpinus',
            275: 'african hunting dog, hyena dog, cape hunting dog, lycaon pictus',
            276: 'hyena, hyaena',
            277: 'red fox, vulpes vulpes',
            278: 'kit fox, vulpes macrotis',
            279: 'arctic fox, white fox, alopex lagopus',
            280: 'grey fox, gray fox, urocyon cinereoargenteus',
            281: 'tabby, tabby cat',
            282: 'tiger cat',
            283: 'persian cat',
            284: 'siamese cat, siamese',
            285: 'egyptian cat',
            286: 'cougar, puma, catamount, mountain lion, painter, panther, felis concolor',
            287: 'lynx, catamount',
            288: 'leopard, panthera pardus',
            289: 'snow leopard, ounce, panthera uncia',
            290: 'jaguar, panther, panthera onca, felis onca',
            291: 'lion, king of beasts, panthera leo',
            292: 'tiger, panthera tigris',
            293: 'cheetah, chetah, acinonyx jubatus',
            294: 'brown bear, bruin, ursus arctos',
            295: 'american black bear, black bear, ursus americanus, euarctos americanus',
            296: 'ice bear, polar bear, ursus maritimus, thalarctos maritimus',
            297: 'sloth bear, melursus ursinus, ursus ursinus',
            298: 'mongoose',
            299: 'meerkat, mierkat',
            300: 'tiger beetle',
            301: 'ladybug, ladybeetle, lady beetle, ladybird, ladybird beetle',
            302: 'ground beetle, carabid beetle',
            303: 'long-horned beetle, longicorn, longicorn beetle',
            304: 'leaf beetle, chrysomelid',
            305: 'dung beetle',
            306: 'rhinoceros beetle',
            307: 'weevil',
            308: 'fly',
            309: 'bee',
            310: 'ant, emmet, pismire',
            311: 'grasshopper, hopper',
            312: 'cricket',
            313: 'walking stick, walkingstick, stick insect',
            314: 'cockroach, roach',
            315: 'mantis, mantid',
            316: 'cicada, cicala',
            317: 'leafhopper',
            318: 'lacewing, lacewing fly',
            319: 'dragonfly, darning needle, devil`s darning needle, sewing needle, snake feeder, snake doctor, mosquito hawk, skeeter hawk',
            320: 'damselfly',
            321: 'admiral',
            322: 'ringlet, ringlet butterfly',
            323: 'monarch, monarch butterfly, milkweed butterfly, danaus plexippus',
            324: 'cabbage butterfly',
            325: 'sulphur butterfly, sulfur butterfly',
            326: 'lycaenid, lycaenid butterfly',
            327: 'starfish, sea star',
            328: 'sea urchin',
            329: 'sea cucumber, holothurian',
            330: 'wood rabbit, cottontail, cottontail rabbit',
            331: 'hare',
            332: 'angora, angora rabbit',
            333: 'hamster',
            334: 'porcupine, hedgehog',
            335: 'fox squirrel, eastern fox squirrel, sciurus niger',
            336: 'marmot',
            337: 'beaver',
            338: 'guinea pig, cavia cobaya',
            339: 'sorrel',
            340: 'zebra',
            341: 'hog, pig, grunter, squealer, sus scrofa',
            342: 'wild boar, boar, sus scrofa',
            343: 'warthog',
            344: 'hippopotamus, hippo, river horse, hippopotamus amphibius',
            345: 'ox',
            346: 'water buffalo, water ox, asiatic buffalo, bubalus bubalis',
            347: 'bison',
            348: 'ram, tup',
            349: 'bighorn, bighorn sheep, cimarron, rocky mountain bighorn, rocky mountain sheep, ovis canadensis',
            350: 'ibex, capra ibex',
            351: 'hartebeest',
            352: 'impala, aepyceros melampus',
            353: 'gazelle',
            354: 'arabian camel, dromedary, camelus dromedarius',
            355: 'llama',
            356: 'weasel',
            357: 'mink',
            358: 'polecat, fitch, foulmart, foumart, mustela putorius',
            359: 'black-footed ferret, ferret, mustela nigripes',
            360: 'otter',
            361: 'skunk, polecat, wood pussy',
            362: 'badger',
            363: 'armadillo',
            364: 'three-toed sloth, ai, bradypus tridactylus',
            365: 'orangutan, orang, orangutang, pongo pygmaeus',
            366: 'gorilla, gorilla gorilla',
            367: 'chimpanzee, chimp, pan troglodytes',
            368: 'gibbon, hylobates lar',
            369: 'siamang, hylobates syndactylus, symphalangus syndactylus',
            370: 'guenon, guenon monkey',
            371: 'patas, hussar monkey, erythrocebus patas',
            372: 'baboon',
            373: 'macaque',
            374: 'langur',
            375: 'colobus, colobus monkey',
            376: 'proboscis monkey, nasalis larvatus',
            377: 'marmoset',
            378: 'capuchin, ringtail, cebus capucinus',
            379: 'howler monkey, howler',
            380: 'titi, titi monkey',
            381: 'spider monkey, ateles geoffroyi',
            382: 'squirrel monkey, saimiri sciureus',
            383: 'madagascar cat, ring-tailed lemur, lemur catta',
            384: 'indri, indris, indri indri, indri brevicaudatus',
            385: 'indian elephant, elephas maximus',
            386: 'african elephant, loxodonta africana',
            387: 'lesser panda, red panda, panda, bear cat, cat bear, ailurus fulgens',
            388: 'giant panda, panda, panda bear, coon bear, ailuropoda melanoleuca',
            389: 'barracouta, snoek',
            390: 'eel',
            391: 'coho, cohoe, coho salmon, blue jack, silver salmon, oncorhynchus kisutch',
            392: 'rock beauty, holocanthus tricolor',
            393: 'anemone fish',
            394: 'sturgeon',
            395: 'gar, garfish, garpike, billfish, lepisosteus osseus',
            396: 'lionfish',
            397: 'puffer, pufferfish, blowfish, globefish',
            398: 'abacus',
            399: 'abaya',
            400: 'academic gown, academic robe, judge`s robe',
            401: 'accordion, piano accordion, squeeze box',
            402: 'acoustic guitar',
            403: 'aircraft carrier, carrier, flattop, attack aircraft carrier',
            404: 'airliner',
            405: 'airship, dirigible',
            406: 'altar',
            407: 'ambulance',
            408: 'amphibian, amphibious vehicle',
            409: 'analog clock',
            410: 'apiary, bee house',
            411: 'apron',
            412: 'ashcan, trash can, garbage can, wastebin, ash bin, ash-bin, ashbin, dustbin, trash barrel, trash bin',
            413: 'assault rifle, assault gun',
            414: 'backpack, back pack, knapsack, packsack, rucksack, haversack',
            415: 'bakery, bakeshop, bakehouse',
            416: 'balance beam, beam',
            417: 'balloon',
            418: 'ballpoint, ballpoint pen, ballpen, biro',
            419: 'band aid',
            420: 'banjo',
            421: 'bannister, banister, balustrade, balusters, handrail',
            422: 'barbell',
            423: 'barber chair',
            424: 'barbershop',
            425: 'barn',
            426: 'barometer',
            427: 'barrel, cask',
            428: 'barrow, garden cart, lawn cart, wheelbarrow',
            429: 'baseball',
            430: 'basketball',
            431: 'bassinet',
            432: 'bassoon',
            433: 'bathing cap, swimming cap',
            434: 'bath towel',
            435: 'bathtub, bathing tub, bath, tub',
            436: 'beach wagon, station wagon, wagon, estate car, beach waggon, station waggon, waggon',
            437: 'beacon, lighthouse, beacon light, pharos',
            438: 'beaker',
            439: 'bearskin, busby, shako',
            440: 'beer bottle',
            441: 'beer glass',
            442: 'bell cote, bell cot',
            443: 'bib',
            444: 'bicycle-built-for-two, tandem bicycle, tandem',
            445: 'bikini, two-piece',
            446: 'binder, ring-binder',
            447: 'binoculars, field glasses, opera glasses',
            448: 'birdhouse',
            449: 'boathouse',
            450: 'bobsled, bobsleigh, bob',
            451: 'bolo tie, bolo, bola tie, bola',
            452: 'bonnet, poke bonnet',
            453: 'bookcase',
            454: 'bookshop, bookstore, bookstall',
            455: 'bottlecap',
            456: 'bow',
            457: 'bow tie, bow-tie, bowtie',
            458: 'brass, memorial tablet, plaque',
            459: 'brassiere, bra, bandeau',
            460: 'breakwater, groin, groyne, mole, bulwark, seawall, jetty',
            461: 'breastplate, aegis, egis',
            462: 'broom',
            463: 'bucket, pail',
            464: 'buckle',
            465: 'bulletproof vest',
            466: 'bullet train, bullet',
            467: 'butcher shop, meat market',
            468: 'cab, hack, taxi, taxicab',
            469: 'caldron, cauldron',
            470: 'candle, taper, wax light',
            471: 'cannon',
            472: 'canoe',
            473: 'can opener, tin opener',
            474: 'cardigan',
            475: 'car mirror',
            476: 'carousel, carrousel, merry-go-round, roundabout, whirligig',
            477: 'carpenter`s kit, tool kit',
            478: 'carton',
            479: 'car wheel',
            480: 'cash machine, cash dispenser, automated teller machine, automatic teller machine, automated teller, automatic teller, atm',
            481: 'cassette',
            482: 'cassette player',
            483: 'castle',
            484: 'catamaran',
            485: 'cd player',
            486: 'cello, violoncello',
            487: 'cellular telephone, cellular phone, cellphone, cell, mobile phone',
            488: 'chain',
            489: 'chainlink fence',
            490: 'chain mail, ring mail, mail, chain armor, chain armour, ring armor, ring armour',
            491: 'chain saw, chainsaw',
            492: 'chest',
            493: 'chiffonier, commode',
            494: 'chime, bell, gong',
            495: 'china cabinet, china closet',
            496: 'christmas stocking',
            497: 'church, church building',
            498: 'cinema, movie theater, movie theatre, movie house, picture palace',
            499: 'cleaver, meat cleaver, chopper',
            500: 'cliff dwelling',
            501: 'cloak',
            502: 'clog, geta, patten, sabot',
            503: 'cocktail shaker',
            504: 'coffee mug',
            505: 'coffeepot',
            506: 'coil, spiral, volute, whorl, helix',
            507: 'combination lock',
            508: 'computer keyboard, keypad',
            509: 'confectionery, confectionary, candy store',
            510: 'container ship, containership, container vessel',
            511: 'convertible',
            512: 'corkscrew, bottle screw',
            513: 'cornet, horn, trumpet, trump',
            514: 'cowboy boot',
            515: 'cowboy hat, ten-gallon hat',
            516: 'cradle',
            517: 'crane',
            518: 'crash helmet',
            519: 'crate',
            520: 'crib, cot',
            521: 'crock pot',
            522: 'croquet ball',
            523: 'crutch',
            524: 'cuirass',
            525: 'dam, dike, dyke',
            526: 'desk',
            527: 'desktop computer',
            528: 'dial telephone, dial phone',
            529: 'diaper, nappy, napkin',
            530: 'digital clock',
            531: 'digital watch',
            532: 'dining table, board',
            533: 'dishrag, dishcloth',
            534: 'dishwasher, dish washer, dishwashing machine',
            535: 'disk brake, disc brake',
            536: 'dock, dockage, docking facility',
            537: 'dogsled, dog sled, dog sleigh',
            538: 'dome',
            539: 'doormat, welcome mat',
            540: 'drilling platform, offshore rig',
            541: 'drum, membranophone, tympan',
            542: 'drumstick',
            543: 'dumbbell',
            544: 'dutch oven',
            545: 'electric fan, blower',
            546: 'electric guitar',
            547: 'electric locomotive',
            548: 'entertainment center',
            549: 'envelope',
            550: 'espresso maker',
            551: 'face powder',
            552: 'feather boa, boa',
            553: 'file, file cabinet, filing cabinet',
            554: 'fireboat',
            555: 'fire engine, fire truck',
            556: 'fire screen, fireguard',
            557: 'flagpole, flagstaff',
            558: 'flute, transverse flute',
            559: 'folding chair',
            560: 'football helmet',
            561: 'forklift',
            562: 'fountain',
            563: 'fountain pen',
            564: 'four-poster',
            565: 'freight car',
            566: 'french horn, horn',
            567: 'frying pan, frypan, skillet',
            568: 'fur coat',
            569: 'garbage truck, dustcart',
            570: 'gasmask, respirator, gas helmet',
            571: 'gas pump, gasoline pump, petrol pump, island dispenser',
            572: 'goblet',
            573: 'go-kart',
            574: 'golf ball',
            575: 'golfcart, golf cart',
            576: 'gondola',
            577: 'gong, tam-tam',
            578: 'gown',
            579: 'grand piano, grand',
            580: 'greenhouse, nursery, glasshouse',
            581: 'grille, radiator grille',
            582: 'grocery store, grocery, food market, market',
            583: 'guillotine',
            584: 'hair slide',
            585: 'hair spray',
            586: 'half track',
            587: 'hammer',
            588: 'hamper',
            589: 'hand blower, blow dryer, blow drier, hair dryer, hair drier',
            590: 'hand-held computer, hand-held microcomputer',
            591: 'handkerchief, hankie, hanky, hankey',
            592: 'hard disc, hard disk, fixed disk',
            593: 'harmonica, mouth organ, harp, mouth harp',
            594: 'harp',
            595: 'harvester, reaper',
            596: 'hatchet',
            597: 'holster',
            598: 'home theater, home theatre',
            599: 'honeycomb',
            600: 'hook, claw',
            601: 'hoopskirt, crinoline',
            602: 'horizontal bar, high bar',
            603: 'horse cart, horse-cart',
            604: 'hourglass',
            605: 'ipod',
            606: 'iron, smoothing iron',
            607: 'jack-o`-lantern',
            608: 'jean, blue jean, denim',
            609: 'jeep, landrover',
            610: 'jersey, t-shirt, tee shirt',
            611: 'jigsaw puzzle',
            612: 'jinrikisha, ricksha, rickshaw',
            613: 'joystick',
            614: 'kimono',
            615: 'knee pad',
            616: 'knot',
            617: 'lab coat, laboratory coat',
            618: 'ladle',
            619: 'lampshade, lamp shade',
            620: 'laptop, laptop computer',
            621: 'lawn mower, mower',
            622: 'lens cap, lens cover',
            623: 'letter opener, paper knife, paperknife',
            624: 'library',
            625: 'lifeboat',
            626: 'lighter, light, igniter, ignitor',
            627: 'limousine, limo',
            628: 'liner, ocean liner',
            629: 'lipstick, lip rouge',
            630: 'loafer',
            631: 'lotion',
            632: 'loudspeaker, speaker, speaker unit, loudspeaker system, speaker system',
            633: 'loupe, jeweler`s loupe',
            634: 'lumbermill, sawmill',
            635: 'magnetic compass',
            636: 'mailbag, postbag',
            637: 'mailbox, letter box',
            638: 'maillot',
            639: 'maillot, tank suit',
            640: 'manhole cover',
            641: 'maraca',
            642: 'marimba, xylophone',
            643: 'mask',
            644: 'matchstick',
            645: 'maypole',
            646: 'maze, labyrinth',
            647: 'measuring cup',
            648: 'medicine chest, medicine cabinet',
            649: 'megalith, megalithic structure',
            650: 'microphone, mike',
            651: 'microwave, microwave oven',
            652: 'military uniform',
            653: 'milk can',
            654: 'minibus',
            655: 'miniskirt, mini',
            656: 'minivan',
            657: 'missile',
            658: 'mitten',
            659: 'mixing bowl',
            660: 'mobile home, manufactured home',
            661: 'model t',
            662: 'modem',
            663: 'monastery',
            664: 'monitor',
            665: 'moped',
            666: 'mortar',
            667: 'mortarboard',
            668: 'mosque',
            669: 'mosquito net',
            670: 'motor scooter, scooter',
            671: 'mountain bike, all-terrain bike, off-roader',
            672: 'mountain tent',
            673: 'mouse, computer mouse',
            674: 'mousetrap',
            675: 'moving van',
            676: 'muzzle',
            677: 'nail',
            678: 'neck brace',
            679: 'necklace',
            680: 'nipple',
            681: 'notebook, notebook computer',
            682: 'obelisk',
            683: 'oboe, hautboy, hautbois',
            684: 'ocarina, sweet potato',
            685: 'odometer, hodometer, mileometer, milometer',
            686: 'oil filter',
            687: 'organ, pipe organ',
            688: 'oscilloscope, scope, cathode-ray oscilloscope, cro',
            689: 'overskirt',
            690: 'oxcart',
            691: 'oxygen mask',
            692: 'packet',
            693: 'paddle, boat paddle',
            694: 'paddlewheel, paddle wheel',
            695: 'padlock',
            696: 'paintbrush',
            697: 'pajama, pyjama, pj`s, jammies',
            698: 'palace',
            699: 'panpipe, pandean pipe, syrinx',
            700: 'paper towel',
            701: 'parachute, chute',
            702: 'parallel bars, bars',
            703: 'park bench',
            704: 'parking meter',
            705: 'passenger car, coach, carriage',
            706: 'patio, terrace',
            707: 'pay-phone, pay-station',
            708: 'pedestal, plinth, footstall',
            709: 'pencil box, pencil case',
            710: 'pencil sharpener',
            711: 'perfume, essence',
            712: 'petri dish',
            713: 'photocopier',
            714: 'pick, plectrum, plectron',
            715: 'pickelhaube',
            716: 'picket fence, paling',
            717: 'pickup, pickup truck',
            718: 'pier',
            719: 'piggy bank, penny bank',
            720: 'pill bottle',
            721: 'pillow',
            722: 'ping-pong ball',
            723: 'pinwheel',
            724: 'pirate, pirate ship',
            725: 'pitcher, ewer',
            726: 'plane, carpenter`s plane, woodworking plane',
            727: 'planetarium',
            728: 'plastic bag',
            729: 'plate rack',
            730: 'plow, plough',
            731: 'plunger, plumber`s helper',
            732: 'polaroid camera, polaroid land camera',
            733: 'pole',
            734: 'police van, police wagon, paddy wagon, patrol wagon, wagon, black maria',
            735: 'poncho',
            736: 'pool table, billiard table, snooker table',
            737: 'pop bottle, soda bottle',
            738: 'pot, flowerpot',
            739: 'potter`s wheel',
            740: 'power drill',
            741: 'prayer rug, prayer mat',
            742: 'printer',
            743: 'prison, prison house',
            744: 'projectile, missile',
            745: 'projector',
            746: 'puck, hockey puck',
            747: 'punching bag, punch bag, punching ball, punchball',
            748: 'purse',
            749: 'quill, quill pen',
            750: 'quilt, comforter, comfort, puff',
            751: 'racer, race car, racing car',
            752: 'racket, racquet',
            753: 'radiator',
            754: 'radio, wireless',
            755: 'radio telescope, radio reflector',
            756: 'rain barrel',
            757: 'recreational vehicle, rv, r.v.',
            758: 'reel',
            759: 'reflex camera',
            760: 'refrigerator, icebox',
            761: 'remote control, remote',
            762: 'restaurant, eating house, eating place, eatery',
            763: 'revolver, six-gun, six-shooter',
            764: 'rifle',
            765: 'rocking chair, rocker',
            766: 'rotisserie',
            767: 'rubber eraser, rubber, pencil eraser',
            768: 'rugby ball',
            769: 'rule, ruler',
            770: 'running shoe',
            771: 'safe',
            772: 'safety pin',
            773: 'saltshaker, salt shaker',
            774: 'sandal',
            775: 'sarong',
            776: 'sax, saxophone',
            777: 'scabbard',
            778: 'scale, weighing machine',
            779: 'school bus',
            780: 'schooner',
            781: 'scoreboard',
            782: 'screen, crt screen',
            783: 'screw',
            784: 'screwdriver',
            785: 'seat belt, seatbelt',
            786: 'sewing machine',
            787: 'shield, buckler',
            788: 'shoe shop, shoe-shop, shoe store',
            789: 'shoji',
            790: 'shopping basket',
            791: 'shopping cart',
            792: 'shovel',
            793: 'shower cap',
            794: 'shower curtain',
            795: 'ski',
            796: 'ski mask',
            797: 'sleeping bag',
            798: 'slide rule, slipstick',
            799: 'sliding door',
            800: 'slot, one-armed bandit',
            801: 'snorkel',
            802: 'snowmobile',
            803: 'snowplow, snowplough',
            804: 'soap dispenser',
            805: 'soccer ball',
            806: 'sock',
            807: 'solar dish, solar collector, solar furnace',
            808: 'sombrero',
            809: 'soup bowl',
            810: 'space bar',
            811: 'space heater',
            812: 'space shuttle',
            813: 'spatula',
            814: 'speedboat',
            815: 'spider web, spider`s web',
            816: 'spindle',
            817: 'sports car, sport car',
            818: 'spotlight, spot',
            819: 'stage',
            820: 'steam locomotive',
            821: 'steel arch bridge',
            822: 'steel drum',
            823: 'stethoscope',
            824: 'stole',
            825: 'stone wall',
            826: 'stopwatch, stop watch',
            827: 'stove',
            828: 'strainer',
            829: 'streetcar, tram, tramcar, trolley, trolley car',
            830: 'stretcher',
            831: 'studio couch, day bed',
            832: 'stupa, tope',
            833: 'submarine, pigboat, sub, u-boat',
            834: 'suit, suit of clothes',
            835: 'sundial',
            836: 'sunglass',
            837: 'sunglasses, dark glasses, shades',
            838: 'sunscreen, sunblock, sun blocker',
            839: 'suspension bridge',
            840: 'swab, swob, mop',
            841: 'sweatshirt',
            842: 'swimming trunks, bathing trunks',
            843: 'swing',
            844: 'switch, electric switch, electrical switch',
            845: 'syringe',
            846: 'table lamp',
            847: 'tank, army tank, armored combat vehicle, armoured combat vehicle',
            848: 'tape player',
            849: 'teapot',
            850: 'teddy, teddy bear',
            851: 'television, television system',
            852: 'tennis ball',
            853: 'thatch, thatched roof',
            854: 'theater curtain, theatre curtain',
            855: 'thimble',
            856: 'thresher, thrasher, threshing machine',
            857: 'throne',
            858: 'tile roof',
            859: 'toaster',
            860: 'tobacco shop, tobacconist shop, tobacconist',
            861: 'toilet seat',
            862: 'torch',
            863: 'totem pole',
            864: 'tow truck, tow car, wrecker',
            865: 'toyshop',
            866: 'tractor',
            867: 'trailer truck, tractor trailer, trucking rig, rig, articulated lorry, semi',
            868: 'tray',
            869: 'trench coat',
            870: 'tricycle, trike, velocipede',
            871: 'trimaran',
            872: 'tripod',
            873: 'triumphal arch',
            874: 'trolleybus, trolley coach, trackless trolley',
            875: 'trombone',
            876: 'tub, vat',
            877: 'turnstile',
            878: 'typewriter keyboard',
            879: 'umbrella',
            880: 'unicycle, monocycle',
            881: 'upright, upright piano',
            882: 'vacuum, vacuum cleaner',
            883: 'vase',
            884: 'vault',
            885: 'velvet',
            886: 'vending machine',
            887: 'vestment',
            888: 'viaduct',
            889: 'violin, fiddle',
            890: 'volleyball',
            891: 'waffle iron',
            892: 'wall clock',
            893: 'wallet, billfold, notecase, pocketbook',
            894: 'wardrobe, closet, press',
            895: 'warplane, military plane',
            896: 'washbasin, handbasin, washbowl, lavabo, wash-hand basin',
            897: 'washer, automatic washer, washing machine',
            898: 'water bottle',
            899: 'water jug',
            900: 'water tower',
            901: 'whiskey jug',
            902: 'whistle',
            903: 'wig',
            904: 'window screen',
            905: 'window shade',
            906: 'windsor tie',
            907: 'wine bottle',
            908: 'wing',
            909: 'wok',
            910: 'wooden spoon',
            911: 'wool, woolen, woollen',
            912: 'worm fence, snake fence, snake-rail fence, virginia fence',
            913: 'wreck',
            914: 'yawl',
            915: 'yurt',
            916: 'web site, website, internet site, site',
            917: 'comic book',
            918: 'crossword puzzle, crossword',
            919: 'street sign',
            920: 'traffic light, traffic signal, stoplight',
            921: 'book jacket, dust cover, dust jacket, dust wrapper',
            922: 'menu',
            923: 'plate',
            924: 'guacamole',
            925: 'consomme',
            926: 'hot pot, hotpot',
            927: 'trifle',
            928: 'ice cream, icecream',
            929: 'ice lolly, lolly, lollipop, popsicle',
            930: 'french loaf',
            931: 'bagel, beigel',
            932: 'pretzel',
            933: 'cheeseburger',
            934: 'hotdog, hot dog, red hot',
            935: 'mashed potato',
            936: 'head cabbage',
            937: 'broccoli',
            938: 'cauliflower',
            939: 'zucchini, courgette',
            940: 'spaghetti squash',
            941: 'acorn squash',
            942: 'butternut squash',
            943: 'cucumber, cuke',
            944: 'artichoke, globe artichoke',
            945: 'bell pepper',
            946: 'cardoon',
            947: 'mushroom',
            948: 'granny smith',
            949: 'strawberry',
            950: 'orange',
            951: 'lemon',
            952: 'fig',
            953: 'pineapple, ananas',
            954: 'banana',
            955: 'jackfruit, jak, jack',
            956: 'custard apple',
            957: 'pomegranate',
            958: 'hay',
            959: 'carbonara',
            960: 'chocolate sauce, chocolate syrup',
            961: 'dough',
            962: 'meat loaf, meatloaf',
            963: 'pizza, pizza pie',
            964: 'potpie',
            965: 'burrito',
            966: 'red wine',
            967: 'espresso',
            968: 'cup',
            969: 'eggnog',
            970: 'alp',
            971: 'bubble',
            972: 'cliff, drop, drop-off',
            973: 'coral reef',
            974: 'geyser',
            975: 'lakeside, lakeshore',
            976: 'promontory, headland, head, foreland',
            977: 'sandbar, sand bar',
            978: 'seashore, coast, seacoast, sea-coast',
            979: 'valley, vale',
            980: 'volcano',
            981: 'ballplayer, baseball player',
            982: 'groom, bridegroom',
            983: 'scuba diver',
            984: 'rapeseed',
            985: 'daisy',
            986: 'yellow lady`s slipper, yellow lady-slipper, cypripedium calceolus, cypripedium parviflorum',
            987: 'corn',
            988: 'acorn',
            989: 'hip, rose hip, rosehip',
            990: 'buckeye, horse chestnut, conker',
            991: 'coral fungus',
            992: 'agaric',
            993: 'gyromitra',
            994: 'stinkhorn, carrion fungus',
            995: 'earthstar',
            996: 'hen-of-the-woods, hen of the woods, polyporus frondosus, grifola frondosa',
            997: 'bolete',
            998: 'ear, spike, capitulum',
            999: 'toilet tissue, toilet paper, bathroom tissue',
        },
        'repo': 'https://github.com/EliSchwartz/imagenet-sample-images.git',
        'plot_size': 5,
        'plot_cmap': None,
    },
}
