# PointHR
This the PyTorch implementation for our paper:
>PointHR: Exploring High-Resolution Architectures for 3D Point Cloud Segmentation

## Installation
We provide the corresponding conda configurations with `environment.yaml`, which can create the working environment by the following command:
```
conda env create -f environment.yaml
```
optional installation:
```
cd libs/pointops
python setup.py install
cd ../..

cd libs/pointops2
python setup.py install
```

## Data Preparation

### ScanNet v2

- Download the [ScanNetV2](https://kaldir.vc.in.tum.de/scannet_benchmark/documentation) dataset.
- Run preprocessing code as follows:
  ```bash
  python pcr/datasets/preprocessing/scannet/preprocess_scannet.py --dataset_root ${RAW_SCANNET_DIR} --output_root ${PROCESSED_SCANNET_DIR}
  ```
- Link the processed dataset to data folder:
  ```bash
  mkdir data
  ln -s ${PROCESSED_SCANNET_DIR} data/scannet
  ```

## Model Zoo
The pretrain model of PointHR-L with 75.4% on val set of ScanNetV2 is available [here](https://drive.google.com/file/d/1Ugzp4dilnZutv9qRyHx3Ehdc8uK0P0Xi/view?usp=share_link). Please download and put it into `checkpoints`.

## Start
Now testing with the pretrained model can be launched by:
```bash
export PYTHONPATH=./

CONFIG_PATH='./configs/scannet/semseg-scannet-pointhr.py'
SAVE_PATH='./output/scannet_val'
CHECKPOINT_PATH='./checkpoints/pointhr_scannet.pth'

GPU='0'
CUDA_VISIBLE_DEVICES=$GPU \
python tools/test.py --config-file ${CONFIG_PATH} --options save_path=${SAVE_PATH} weight=${CHECKPOINT_PATH}
```

## Acknowledgement
This repo is built based on [Point Transformer V2](https://github.com/Gofinge/PointTransformerV2). 
