# TRACE Deployment Gate Artifact - Environment

This file provides details on the hardware and software environment required to run the artifact's experiments.

## Software

We provide two ways to set up the Python environment:

### Option A: Conda (Recommended)

This is the easiest way to ensure all dependencies are correctly installed.

```bash
conda env create -f environment.yml
conda activate trace
```

### Option B: pip

If you prefer not to use Conda, you can use `pip` with a virtual environment.

```bash
python -m venv .venv
source .venv/bin/activate
pip install -r requirements.txt
```

## Hardware

- **GPU:** A single NVIDIA GPU with at least 11GB of VRAM is recommended for reasonable performance.
- **CUDA:** The code is tested with CUDA 11+. A CPU-only fallback is possible, but it will be significantly slower.

## Datasets

The experiment requires the `real` and `sketch` splits of the DomainNet dataset. The included download script will handle this automatically. After running the script, the data will be located at:
`data/domainnet/`

