from __future__ import annotations

import numpy as np
from scipy.stats import spearmanr


def spearman_rho(x: np.ndarray, y: np.ndarray) -> float:
    rho, _ = spearmanr(x, y)
    return float(rho)




