from __future__ import annotations

from dataclasses import dataclass
import numpy as np
from sklearn.linear_model import LogisticRegression


@dataclass
class LogisticConfig:
    C: float = 1.0
    penalty: str = "l2"
    solver: str = "lbfgs"
    max_iter: int = 200
    random_state: int | None = None


def train_logistic(X: np.ndarray, y: np.ndarray, config: LogisticConfig) -> LogisticRegression:
    model = LogisticRegression(C=config.C, penalty=config.penalty, solver=config.solver, max_iter=config.max_iter, random_state=config.random_state)
    model.fit(X, y)
    return model




