#!/usr/bin/env bash
set -euo pipefail

OUTDIR="trace_bench/reports/$(date +%Y%m%d_%H%M%S)"
mkdir -p "$OUTDIR"

python -m trace_bench.run --world blobs_shift --grid trace_bench/configs/blobs.yaml --use_sinkhorn --use_mmd --q 0.90 --sinkhorn_eps 0.05 --iters 300 --output "$OUTDIR/blobs"
python -m trace_bench.run --world moons_warp --grid trace_bench/configs/moons.yaml --use_sinkhorn --q 0.95 --sinkhorn_eps 0.05 --iters 300 --output "$OUTDIR/moons"

echo "Reports saved under $OUTDIR"


