# Bridging Theory and Practice in Link Representation with Graph Neural Networks

## Anonymized Repository for NeurIPS 2025 Submission

This repository contains the source code and instructions to reproduce the experiments for our NeurIPS 2025 submission.

### 📦 Requirements

This project was developed and tested with Python 3.9. All dependencies can be installed via:

```bash
pip install -r requirements.txt
```
This project was developed and tested with Python 3.9.

### 📁 Repository Structure
```bash
.
├── requirements.txt
├── README.md
├── synthetic/
│   └── models/
│       ├── gnn_synthetic.py
│       ├── ncn_synthetic.py
│       └── ...
├── baselines/
│   ├── download_data.sh
│   ├── small/
│   │   ├── gnn_small.py
│   │   ├── ncn_small.py
│   │   └── ...
│   └── ogb/
│       ├── gnn_ogb.py
│       ├── ncn_ogb.py
│       └── ...
```

### Synthetic Experiments

To run the experiments on the synthetic dataset:

```bash
cd synthetic/models
python gnn_synthetic.py  # or any of the other model scripts
```

Each script in this folder corresponds to a specific model variant evaluated on the synthetic graph data.

### Real-World Datasets
#### Step 1: Download the datasets

Before running experiments on real-world datasets, download the required files with:

```bash
bash download_data.sh
```

#### Step 2: Run the experiments
Small datasets

```bash
cd small
python gnn_small.py  # or ncn_small.py, etc.
```

OGB datasets
```bash
cd ogb
python gnn_ogb.py  # or ncn_small.py, etc.
```