import numpy as np
from tqdm import tqdm
from pathlib import Path

import time



from detectors import RoBERTaAIDetector, OpenAIDetector
from my_utils.data_utils import save_list_to_tsv, load_list_from_tsv
from my_utils.my_dataloader import load_test_data
from my_openai.openai_wrapper import chatgpt_completion
import shared_dir


human_prompt = "When it comes to writing content, two factors are crucial, \"perplexity\" and \"burstiness\". Perplexity " \
               "measures the complexity of text. Separately, burstiness compares the variations of sentences. " \
               "Humans tend to write with greater burstiness, for example, with some longer or complex sentences alongside " \
               "shorter ones. AI sentences tend to be more uniform."

def paraphrase_human_chatgpt(orig_text):

    messages = [
        {"role": "user",
         "content": f"{human_prompt}\nParaphrase the following AI sentence to be human-like, with a good amount of perplexity and burstiness:\n {orig_text}"}
    ]

    completion = chatgpt_completion(messages, temperature=1)
    return completion['choices'][0]['message']['content']


baseline_name = 'human_prompt'
dataset = ''
task_type = 'paraphrase'

# load test
test_data_list = load_test_data(dataset, task_type)


all_data_list = []
new_data_list = []
for ai_t in tqdm(test_data_list):
    humanlike_t = paraphrase_human_chatgpt(ai_t)
    all_data_list.append((ai_t, humanlike_t)) # human-like ai, ai
    new_data_list.append(humanlike_t)

all_data_list.insert(0, ['ai', 'prompt paraphrased'])

# # save
output_folder = Path(shared_dir.test_results_dir, dataset, baseline_name)
output_folder.mkdir(parents=True, exist_ok=True)
save_list_to_tsv(all_data_list, output_folder.joinpath('generated_text.tsv'))