# Large Language Models can be Guided to Evade AI-Generated Text Detection

This document shows how to reimplement all results introduced in our paper, including SICO and other baselines.

## Requirements
Create environment by conda:

``
conda env create -f environment.yml
``

## LLM setup

- For chatgpt, you need to modify the OpenAI API keys in `my_openai/openai_settings.py`.

- For Vicuna, please follow the instruction [here](https://github.com/lm-sys/FastChat). And set the local url in `sico/LLM_api.py`.

## Detectors setup

- `GPT2 detector`: Follow the instructions from [repo](https://github.com/openai/gpt-2-output-dataset/tree/master/detector) on github.
- `GPTzero`: Set the GPTzero API key in `detectors`. Key can be obtained from [GPTzero website](https://gptzero.me/).
- `OpenAI detector`: Set the OpenAI API keys in `my_openai/openai_settings.py`.
- `ChatGPT detector, DetectGPT, Log-Rank`: Required models will be automatically download model from HuggingFace.

## Datasets
All datasets we used are listed in `datasets` folder, containing `squad,eli5,yelp`.
Each subfolder has three tsv files: `eval.tsv` for training evaluation, `test.tsv` for final test, and `incontext.tsv` for initialization.

## Word Substitution

Run `sico/cand_dict_generator.py` to generate word substitution dictionary based on WordNet.
We use the [Stanford Pos Tagger](https://nlp.stanford.edu/software/tagger.shtml) to measure the Part-Of-Speech.

## SICO
### Training

Run `SICO_train.py` to start training procedure.

Here we explain each required argument in details:

- `--dataset`: Dataset we use, including `[squad, eli5, yelp]`
- `--llm`: Base LLM used for training, including `[chatgpt, vicuna]`
- `--detector`: Proxy detector we use for training, including `['chatdetect', 'gpt2detect', 'gptzero', 'openai', 'detectgpt', 'logrank']`
- `--task`: The task type of training, including `['essay', 'qa', 'rev-gen', 'paraphrase']`. Notice that `paraphrase` task matches all dataset, but `essay, qa, rev-gen` tasks only match `squad, eli5, yelp`, respectively.
- `--incontext-size`: Size of in-context examples.
- `--eval-size`: Size of evaluation data during training.
- `--train-iter`:  Maximum training iteration.


Reimplement of SICO-gen on essay writing task:

```
python SICO_train.py 
    --dataset squad 
    --llm chatgpt 
    --detector chatdetect 
    --task essay
    --incontext-size 8
    --eval-size 32
    --train-iter 6
```

Reimplement of SICO-para for open-ended question answering task:
```
python SICO_train.py 
    --dataset yelp 
    --llm chatgpt 
    --detector chatdetect 
    --task paraphrase
    --incontext-size 8
    --eval-size 32
    --train-iter 6
```

After training, the optimized results is stored in `./outputs/results/`

### test

Run `SICO_test_gen.py` to use constructed prompt to generate texts, the arguments are the same as `SICO_train.py`.

After running `SICO_test_gen.py`, the generated texts are stored in `test_results/{dataset}/sico-*`. 
Then use  `./eval_scripts/get_metric.py` to get AUC performance.


## Baselines
Scripts of all four baselines are listed in folder `baselines`. 
Change the `dataset` variable and run the scripts to generate texts, which are also stored in `test_results/{dataset}/{baseline name}`.
