from my_utils.text_utils import escape_curly_braces





class PromptConstructor:

    def __init__(self, dataset, task_type):

        self.text_type = 'writing'
        self.task_type = task_type
        self.dataset = dataset

        assert self.task_type in {'essay', 'qa', 'rev-gen', 'paraphrase'}

    def prompt_extract_feature(self, human_task_outputs, ai_task_outputs):
        # The prompt in step 1: compare and extract the features from AI and Humans
        cur_prompt = 'Here are the {} pairs from two people P1 and P2:\n'.format(self.text_type)

        for i in range(len(human_task_outputs)):
            ai_data = ai_task_outputs[i]
            human_data = human_task_outputs[i]

            # if self.task_type == 'qa':
            #     cur_prompt += f'Question: {task_inputs[i]}\n'

            cur_prompt += f'P1: {ai_data}\n'
            cur_prompt += f'P2: {human_data}\n\n'


        instruction_str = '\nBased on the given pairs, what are the unique features of P2\'s {}s.'.format(
            self.text_type)

        cur_prompt += instruction_str

        cur_prompt += ' Be clear and concise so I can use the answer to guide my writing.'

        return cur_prompt

    def clean_feature_prompt(self):

        cur_prompt = '''Remove the example parts when describing P2\'s writing style and keep other parts same.'''
        cur_prompt += '''\nHint: the example parts usually starte with 'such as', 'like', 'for examples', etc.\n\nOrigin: {}\n\nNew:'''


        return cur_prompt


    def _process_incontext_string(self, incontext_examples):

        new_incontext_examples = []
        for ice in incontext_examples:
            new_ice = []
            for s in ice:
                new_ice.append(escape_curly_braces(s))
            new_incontext_examples.append(new_ice)

        return new_incontext_examples



    def get_final_prompt(self, feature_text, incontext_examples):
        if self.task_type == 'essay':
            return self.get_final_prompt_essay(feature_text, incontext_examples)
        elif self.task_type == 'qa':
            return self.get_final_prompt_qa(feature_text, incontext_examples)
        elif self.task_type == 'rev-gen':
            return self.get_final_prompt_revgen(feature_text, incontext_examples)
        elif self.task_type == 'paraphrase':
            return self.get_final_prompt_paraphrase(feature_text, incontext_examples)
        else:
            raise Exception('Wrong task', self.task_type)

    def get_final_prompt_qa(self, feature_text, incontext_examples):
        prompt_str = '''{}\nBased on the description, answer questions in P2 style {}s:\n'''.format(feature_text, self.text_type)

        for x_ic, y_ic in incontext_examples:
            prompt_str += 'Q: {}\nP2: {}\n\n'.format(x_ic, y_ic)

        prompt_str += '''Q: {}\nP2:'''

        return prompt_str

    def get_final_prompt_essay(self, feature_text, incontext_examples):
        prompt_str = '''{}\nBased on the description, complete academic paragraph in P2 style {}s:\n'''.format(feature_text, self.text_type)

        # prompt_str = '''{}\nBased on the description, rewrite this to P2 style writings in {}:\n'''.format(extract_info, self.text_type)

        # append each icd
        for x_ic, y_ic in incontext_examples:
            prompt_str += 'Prompt: {}\nP2: {}\n\n'.format(x_ic, y_ic)

        prompt_str += '''Prompt: {}\nP2:'''

        return prompt_str


    def get_final_prompt_revgen(self, feature_text, incontext_examples):
        prompt_str = '''{}\nBased on the description, write a P2 style review about given object and key words, with specified sentiment:\n'''.format(feature_text)

        # append each icd
        for x_ic, y_ic in incontext_examples:
            prompt_str += '{}\nP2: {}\n\n\n'.format(x_ic, y_ic)

        prompt_str += '''{}\nP2:'''

        return prompt_str

    def get_final_prompt_paraphrase(self, feature_text, incontext_examples):
        prompt_str = '''{}\nBased on the description, rewrite this to P2 style {}:\n'''.format(feature_text,
                                                                                               self.text_type)

        for x_ic, y_ic in incontext_examples:
            prompt_str += 'Origin: {}\nP2: {}\n\n'.format(x_ic, y_ic)

        prompt_str += '''Origin: {}\nP2:'''

        return prompt_str


