# Neural networks and the Chomsky hierarchy

This zip file contains the official implementation of the paper Neural networks and the Chomsky hierarchy.

## Content

There are three folders: tasks, models and training.

'tasks' contains all tasks, organized in their Chomsky hierarchy levels (regular, dcf, cs). They all inherit the abstract class GeneralizationTask, defined in tasks/task.py.

'models' contains all the models we use, written in [jax](https://github.com/google/jax) and [haiku](https://github.com/deepmind/dm-haiku), two open source libraries. We also use [numpy](https://github.com/numpy/numpy).

'training' contains the code for training models and evaluating them on a wide range of lengths. We also included an example to train and evaluate an RNN on the Even Pairs task. For training, we use [optax](https://github.com/deepmind/optax) for our optimizers.


## Dependencies

Dependencies are summarized in the requirements.txt file. Links:

* [chex](https://github.com/deepmind/chex): type checking
* [jax](https://github.com/google/jax) : tensor manipulation.
* [haiku](https://github.com/deepmind/dm-haiku) : building neural networks.
* [numpy](https://github.com/numpy/numpy) : tensor manipulation.
* [optax](https://github.com/deepmind/optax) : optimizers (Adam here).
* [tqdm](https://github.com/tqdm/tqdm) : progress bar.
* [einshape](https://github.com/deepmind/einshape) : used for the NDStack-RNN, which requires heavy tensor manipulation.
* [tree](https://github.com/deepmind/tree) : used in some tasks, for data manipulation.
* [abseil](https://github.com/abseil/abseil-py) : used in the example launch.

