#!/bin/bash

OUTPUT_DIR="./output_dir"  # log_dir
CFG_PATH="./configs/pretraining.yaml"  # yaml file for dataset configuration

for var in 4 5 6 7;
do
if [ -z ${VISIBLE_DEVICES} ]; then
    VISIBLE_DEVICES=${VISIBLE_DEVICES}$((var))
else
    VISIBLE_DEVICES=${VISIBLE_DEVICES},$((var))
fi
done
export CUDA_VISIBLE_DEVICES=${VISIBLE_DEVICES}

NUM_GPUS=4  # number of GPUs

python -m torch.distributed.launch \
--nproc_per_node=${NUM_GPUS} \
--master_port=12346 \
main_pretrain.py \
--batch_size 128 \
--epochs 800 \
--accum_iter 2 \
--model st_mem_vit_base \
--seq_len 2250 \
--patch_size 75 \
--num_leads 12 \
--decoding leadwise \
--mask_ratio 0.75 \
--norm_pix_loss \
--weight_decay 0.01 \
--blr 1.5e-4 \
--warmup_epochs 40 \
--output_dir ${OUTPUT_DIR} \
--log_dir ${OUTPUT_DIR} \
--num_workers 4 \
--no_pin_mem \
--cfg_file ${CFG_PATH}
