# Contributing to TorchRay

We want to make contributing to this project as easy and transparent as possible.

## Pull Requests

We actively welcome your pull requests.

1. Fork the repo and create your branch from `master`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the test passes (for basic testing use `examples.run_all_examples()`)
5. Make sure your code lints.
6. If you haven't already, complete the Contributor License Agreement ("CLA").

## Contributor License Agreement ("CLA")

In order to accept your pull request, we need you to submit a CLA. You only need to do this once to work on any of Facebook's open source projects.

Complete your CLA here: <https://code.facebook.com/cla>

## Issues

We use GitHub issues to track public bugs. Please ensure your description is clear and has sufficient instructions to be able to reproduce the issue.

## Coding Style

We follow the PEP8 standard using flake8 for linting. For the documentation, we use Sphinx and Napoleon using the Google style for the comments, and LaTeX math for equations.

## License

By contributing to TorchRay, you agree that your contributions will be licensed under the LICENSE file in the root directory of this source tree.
