import importlib


def create_optimizer(weights, kwargs: dict):
    optimizer_name = kwargs['name']
    kwargs = kwargs.copy()
    kwargs.pop('name')

    p, m = optimizer_name.rsplit('.', 1)  # p is module(filename), m is Class Name

    module_name = p
    module_obj = importlib.import_module(module_name)
    optimizer = getattr(module_obj, m)

    return optimizer(weights, **kwargs)


def create_scheduler(optimizer, scheduler_args):
    if scheduler_args:
        scheduler_name = scheduler_args['name']
        kwargs = scheduler_args.copy()
        kwargs.pop('name')

        p, m = scheduler_name.rsplit('.', 1)  # p is module(filename), m is Class Name

        module_name = p
        module_obj = importlib.import_module(module_name)
        scheduler = getattr(module_obj, m)

        return scheduler(optimizer, **kwargs)

    return None
