function auroc = compare(file, innumber, preprocess)
X = load("oc_data/oc_"+file+".mat");
data0 = X.x.data;
target = X.x.nlab;
data = unit_var(data0, preprocess);
[indx, outdx] = find_indis(target, innumber);
l = min(length(indx), 5);
indis = data(indx, 1:end);
inmean = mean(indis);
innorm = max(sum(indis.^2, 2));

score = zeros(length(data), 1);
for i = 1:length(data)
    score(i) = 1 - 0.5*(norm(data(i,1:end) - inmean)/innorm + findnorm(innorm, norm(data(i,1:end))));
end

[tpr,fpr] =cal_roc(sort(score(indx)),sort(score(outdx)));
auroc = trapz(fpr,tpr);
end


