import sys
sys.path.append('/home/minsu/bias/Boolean/')
from pytorch_lightning.utilities.cli import LightningCLI
from datamodule import BooleandataModule
from model import BooleanModel
from common import *
from pytorch_lightning.loggers import WandbLogger
import os

#import os
#os.environ["WANDB_DISABLED"] = "true"

## Create an experiment with your api key.


class CLI(LightningCLI):
   def add_arguments_to_parser(self, parser: Any) -> None:
        parser.link_arguments("data.task", "model.task")  # stepwise는 model에만 명시됨, 그 value가 data로 propagate
        parser.link_arguments("model.method", "data.method")
        parser.link_arguments("model.model_type","data.model_type")


def main() -> None:
    wandb_logger = WandbLogger(project="Boolean_new",e)
    cli = CLI(BooleanModel, BooleandataModule, save_config_overwrite=True)
    print("Configuration: \n", cli.config)


if __name__ == "__main__":
    main()
