README.txt

\===========================================
Subgraph Plug-in (SP) for PyTorch Geometric
===========================================

1. OVERVIEW
   The codebase implements the Subgraph Plug-in (SP) method as a lightweight method for existing GNNs. It is built on PyTorch Geometric and enables both graph classification and regression tasks. SP extracts and embeds high-centrality subgraphs, merges their representations, and feeds the combined embedding to a downstream predictor.

2. REQUIREMENTS
3. 
   • Python 3.7 or higher
   
   • PyTorch ≥1.10
   
   • PyTorch Geometric ≥2.0
   
   • torch\_scatter, torch\_sparse, torch\_cluster, torch\_spline\_conv (matching PyG version)
   • NumPy
   
   • scikit-learn

4. DIRECTORY STRUCTURE
   • model/
   
    – Contains all relocated benchmark models and custom SP extensions
   
   • SP.py
   
    – Example script demonstrating the proposed method
   
   • main.ipynb
   
    – Jupyter notebook orchestrating data loading, model instantiation, training, and evaluation
   
   • README.txt
   
    – This file
   
   • requirements.txt
   
    – pakage file

5. USAGE
   - Copy all files from PyG’s kernel\_benchmark/ into the local model/ folder.
   – Launch Jupyter and open `main.ipynb`.
   – Execute cells sequentially to:

      Load dataset and subgraph extraction utilities
      
      Instantiate base GIN/GCN and SP modules
      
      Train or evaluate classification and regression models

6. Description of SP.py
   - Shared embedding of each extracted subgraph via the same GNN model
   - Concatenation of all subgraph embeddings
   - Downstream classifier/regressor on the combined embedding



7. GPU PARALLELIZATION
Full distributed-training scripts will be released in a future update.

