import pandas as pd

from .base_io import File


class CodeDescriptionFile(File):
    def _load(self, path):
        desc_pd = pd.read_csv(
            path,
            usecols=['ICD9_CODE', 'LONG_TITLE'],
            converters={
                'ICD9_CODE': str, 'LONG_TITLE': str
            }
        )
        return desc_pd

    def _save(self, path, content):
        pass


class LabelCSVFile(File):
    def _load(self, path):
        notes = pd.read_csv(path,
                            usecols=['HADM_ID', 'LABELS'],
                            converters={
                                'HADM_ID': str, 'LABELS': str
                            })
        return notes

    def _save(self, path, content):
        pass
