#! /bin/bash
echo "This script should not take more than a minute to run."
python -m src.probe_llm +experiment=particularised ++seed=1 ++model_ids=gpt2-medium ++objectives=lm ++max_num_evaluations=5 &> temp.txt
rm test.csv
rm raw.csv
results_file=$(cat temp.txt | sed -n -e 's/^.*results to: //p')
data_file=$(cat temp.txt | sed -n -e 's/^.*data to: //p')
accuracy=$(cat "${results_file}" | sed -n -e 's/^.*        "mean_accuracy": //p')
if [[ "${accuracy}" = "50.0," ]]
then
  echo "PASSED"
  rm "${results_file}"
  rm "${data_file}_implicature.json"
  rm temp.txt
  rm probe_llm.log
  rmdir results
else
  echo "FAILED. Required accuracy 50.0 but got ${accuracy}. Check temp.txt or probe_llm.log for clues on what went wrong."
fi