#!/bin/bash
# Default values
model_path="path/to/rm"
chat_template=""
dataset_path="./carb_data"
lang_subset="all"
debug=false
use_sglang=false

# Parse command line options
usage() {
  echo "Usage: $0 [-m MODEL_PATH] [-c CHAT_TEMPLATE] [-d DATASET_PATH] [-l LANG_SUBSET] [-D] [-S]"
  echo "  -m MODEL_PATH          Path to the model (default: ${model_path})"
  echo "  -c CHAT_TEMPLATE       Chat template to use"
  echo "  -d DATASET_PATH        Path to dataset (default: ${dataset_path})"
  echo "  -l LANG_SUBSET         Language subset (default: all)"
  echo "  -D                     Enable debug mode"
  echo "  -S                     Use SGLang as backend"
  echo "  -h                     Display this help message"
  exit 1
}

while getopts "m:c:d:l:DSh" opt; do
  case ${opt} in
    m )
      model_path=$OPTARG
      ;;
    c )
      chat_template=$OPTARG
      ;;
    d )
      dataset_path=$OPTARG
      ;;
    l )
      lang_subset=$OPTARG
      ;;
    D )
      debug=true
      ;;
    S )
      use_sglang=true
      ;;
    h )
      usage
      ;;
    \? )
      usage
      ;;
  esac
done

# Automatically detect number of GPUs
num_gpus=$(nvidia-smi --query-gpu=name --format=csv,noheader | wc -l)
echo "Detected ${num_gpus} GPUs"

cd path/to/CARB

echo "Evaluating Generative RM ${model_path}"

# cmd="python scripts/run_generative_v2.py --model=${model_path} --num_gpus=${num_gpus} --dataset=${dataset_path} --lang_subset=${lang_subset} --disable_beaker_save --score_w_ratings"

cmd="python scripts/run_generative_v2.py --model=${model_path} --num_gpus=${num_gpus} --dataset=${dataset_path} --lang_subset=${lang_subset} --disable_beaker_save"

if [ -n "$chat_template" ]; then
  cmd="${cmd} --chat_template=${chat_template}"
fi

if [ "$debug" = true ]; then
  cmd="${cmd} --debug"
fi

if [ "$use_sglang" = true ]; then
  cmd="${cmd} --use_sglang"
fi

# Execute the command
echo "Running command: ${cmd}"
eval ${cmd}