# Code Guide for ICLR 2023 Submission "Knowledge-Consistent Dialogue Generation with Langauge Models and Knowledge Graphs"

Please download OpendialKG dataset from the official repository to the folder "./dataset/opendialkg" to run our code.

## Data preprocessing
```
cd dataset/opendialkg
python build_codebook.py
python preprocess_global.py
```

## How to Run
```bash
python main.py
```

This code runs 30 epochs of training with T5-small. It costs approximately 10 hours on a single Quadro 8000 GPU.

## How to Run KQA
Due to the space limits on the supplementary files, we cannot provide the fine-tuned checkpoint for the KQA. If you are interested in, please run the following code.
```bash
cd evaluation
python main.py --read_data
python evaluate.py --checkpoint ./save/checkpoint --data_dir ../dataset/opendialkg/ --prediction_file ../save/SAVE_PATH/test_candidate.txt --evaluate_on_test
```