function [ pdf ] = gsp_free_conv_norm_semi(xx)

% Inputs:
% 1. A vector of x's at which to evaluate phi(x)
% 2. The phi_k coefficients, an increasing order starting from
% -approx_order to approx_order (to be loaded in the function)
%
%   Url: https://epfl-lts2.github.io/gspbox-html/doc/filters/utils/gsp_free_conv_norm_semi.html

% Copyright (C) 2013-2016 Nathanael Perraudin, Johan Paratte, David I Shuman.
% This file is part of GSPbox version 0.7.5
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.

% If you use this toolbox please kindly cite
%     N. Perraudin, J. Paratte, D. Shuman, V. Kalofolias, P. Vandergheynst,
%     and D. K. Hammond. GSPBOX: A toolbox for signal processing on graphs.
%     ArXiv e-prints, Aug. 2014.
% http://arxiv.org/abs/1408.5781

% Output: phi(xx), the pdf of the free convolution of the standard normal
% distribution with the semiciruclar distribution with R=2

% Uses the synthesis formula: phi(x)=sum_{k=-inf}^{inf} phi_k [(i-x)/(i+x)]^k

phi_k=[-7.08488319617472e-06 -  7.21304067113176e-17i
       1.86863786028915e-05 -  1.40327227190806e-17i
       -1.0209803329289e-05 +  2.15883816159852e-17i
        1.4158962575414e-07 -   3.3401566955792e-17i
       1.39666404435093e-05 -  3.17485865520183e-19i
      -2.44084178534541e-05 -  2.63127124628966e-18i
       2.63265047949423e-05 -  3.01485701816489e-17i
      -1.65926047249586e-05 -  4.04912288945963e-17i
      -5.70457757358341e-06 -  3.71311273362231e-17i
       3.20890178008145e-05 -  3.99490244314264e-17i
      -4.99704223744881e-05 +  9.95616850330247e-18i
       5.27864277849904e-05 +  1.05596301176939e-17i
      -2.58331165281154e-05 +  1.78948233507735e-17i
      -2.35346501422346e-05 +   7.6777229774625e-18i
       7.98065596587227e-05 -  8.13337968257608e-18i
      -0.000118762196794526 +  4.69910386069309e-18i
       0.000107981543969155 -  2.29584370142318e-17i
      -4.08431414412007e-05 -  1.85343223482883e-18i
      -7.19752379076375e-05 +  2.17482086023201e-17i
        0.00019681995722435 -  1.83538673847635e-17i
      -0.000271452327482758 +  1.27889290682062e-17i
       0.000237043232402955 +  5.35116907332391e-17i
      -6.44493269880619e-05 +  1.58028324183121e-17i
      -0.000220064751332132 -  1.74806450399028e-17i
       0.000513305097957454 +  2.80379506044636e-19i
      -0.000667201022206444 +  1.38784624724107e-17i
       0.000534231890644531 -  5.40062485652753e-18i
      -4.79699143825395e-05 -  5.35371823315673e-18i
       -0.00070768912196828 +   4.9567351129979e-18i
        0.00145967847923333 -  7.12380537738184e-19i
       -0.00178122987588551 +  9.51538928885628e-18i
        0.00123253952108798 -  3.63010386196353e-17i
       0.000414599002217216 -  6.38132867462196e-18i
       -0.00291319197917784 +  1.57183510045138e-18i
        0.00531931722531387 +  4.97917916104092e-18i
        -0.0058930561091161 -  5.68420392701359e-17i
        0.00223692853609744 -  2.05856515900588e-17i
        0.00830827544560402 -  9.98514562047917e-18i
        -0.0280546382324983 -  3.17160971098103e-17i
         0.0582559187063965 +  5.76841109479372e-17i
          0.163264255786455                         
         0.0582559187063965 -  5.76841109479372e-17i
        -0.0280546382324983 +  3.17160971098103e-17i
        0.00830827544560402 +  9.98514562047917e-18i
        0.00223692853609744 +  2.05856515900588e-17i
        -0.0058930561091161 +  5.68420392701359e-17i
        0.00531931722531387 -  4.97917916104092e-18i
       -0.00291319197917784 -  1.57183510045138e-18i
       0.000414599002217216 +  6.38132867462196e-18i
        0.00123253952108798 +  3.63010386196353e-17i
       -0.00178122987588551 -  9.51538928885628e-18i
        0.00145967847923333 +  7.12380537738184e-19i
       -0.00070768912196828 -   4.9567351129979e-18i
      -4.79699143825395e-05 +  5.35371823315673e-18i
       0.000534231890644531 +  5.40062485652753e-18i
      -0.000667201022206444 -  1.38784624724107e-17i
       0.000513305097957454 -  2.80379506044636e-19i
      -0.000220064751332132 +  1.74806450399028e-17i
      -6.44493269880619e-05 -  1.58028324183121e-17i
       0.000237043232402955 -  5.35116907332391e-17i
      -0.000271452327482758 -  1.27889290682062e-17i
        0.00019681995722435 +  1.83538673847635e-17i
      -7.19752379076375e-05 -  2.17482086023201e-17i
      -4.08431414412007e-05 +  1.85343223482883e-18i
       0.000107981543969155 +  2.29584370142318e-17i
      -0.000118762196794526 -  4.69910386069309e-18i
       7.98065596587227e-05 +  8.13337968257608e-18i
      -2.35346501422346e-05 -   7.6777229774625e-18i
      -2.58331165281154e-05 -  1.78948233507735e-17i
       5.27864277849904e-05 -  1.05596301176939e-17i
      -4.99704223744881e-05 -  9.95616850330247e-18i
       3.20890178008145e-05 +  3.99490244314264e-17i
      -5.70457757358341e-06 +  3.71311273362231e-17i
      -1.65926047249586e-05 +  4.04912288945963e-17i
       2.63265047949423e-05 +  3.01485701816489e-17i
      -2.44084178534541e-05 +  2.63127124628966e-18i
       1.39666404435093e-05 +  3.17485865520183e-19i
        1.4158962575414e-07 +   3.3401566955792e-17i
       -1.0209803329289e-05 -  2.15883816159852e-17i
       1.86863786028915e-05 +  1.40327227190806e-17i
      -7.08488319617472e-06 +  7.21304067113176e-17i ];
  
M=length(phi_k);
approx_order=(M-1)/2;

synthesis_fn=@(x) real(sum((((1i-x)/(1i+x)).^(-approx_order:approx_order)).*phi_k'));

pdf=zeros(size(xx));
for k=1:length(xx)
    pdf(k)=synthesis_fn(xx(k));
end

end

